/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.shared;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    public static final String DATE_FORMAT_DD_MM_YYYY = "dd.MM.yyyy";
    public static final String DATE_FORMAT_DD_MM_YYYY_HH_MM_SS = "dd.MM.yyyy HH:mm:ss";
    public static final String DATE_FORMAT_DD_MM_YYYY_HH_MM_SS_UNDERSCORES = "dd_MM_yyyy_HH_mm_ss";

    public static boolean isPositive(Number number) {
        return number != null && number.intValue() >= 0;
    }

    public static boolean isNumeric(String str) {
        if (str != null && !str.trim().isEmpty()) {
            try {
                Long.valueOf(str);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static <T> T getFirstElementOfCollection(Collection<T> col) {
        return Utils.isCollectionEmpty(col) ? null : (T)col.iterator().next();
    }

    public static boolean isCollectionEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static String nvl(String s) {
        return s == null ? "" : s;
    }

    public static <T> T nvl(T t1, T t2) {
        return t1 == null ? t2 : t1;
    }

    public static <T> T nvl(T t1, Supplier<T> t2) {
        return t1 == null ? t2.get() : t1;
    }

    public static <T> Collection<T> nvlCollection(Collection<T> col) {
        return col != null ? col : new ArrayList();
    }

    public static <T, K> Map<T, K> nvlMap(Map<T, K> map) {
        return map != null ? map : new HashMap();
    }

    public static <T extends Comparable<T>> T min(T ... t) {
        if (t == null || t.length == 0) {
            return null;
        }
        return (T)((Comparable)Arrays.asList(t).stream().min(Utils.getDefaultComparator()).orElse(null));
    }

    public static <T extends Comparable<T>> Comparator<T> getDefaultComparator() {
        return (o1, o2) -> o1.compareTo(o2);
    }

    public static Integer asInteger(String str) {
        return Utils.isEmpty(str) ? null : Integer.valueOf(str);
    }

    public static String asString(Integer i) {
        return i == null ? null : String.valueOf(i);
    }

    public static void safeClose(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isEqual(Object o1, Object o2) {
        if (Objects.equals(o1, o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            return ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0;
        }
        return false;
    }

    public static void delay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Integer bigDecimal2Integer(BigDecimal bd) {
        return bd == null ? null : Integer.valueOf(bd.intValue());
    }

    public static Integer bigInteger2Integer(BigInteger bi) {
        return bi == null ? null : Integer.valueOf(bi.intValue());
    }

    public static <T> boolean addToCollectionIfNotNull(Collection<T> col, T t) {
        if (col != null && t != null) {
            return col.add(t);
        }
        return false;
    }

    public static String localDateToString(LocalDate ld) {
        if (ld != null) {
            return Utils.localDateTimeToString(ld.atStartOfDay(), DATE_FORMAT_DD_MM_YYYY);
        }
        return null;
    }

    public static String localDateTimeToString(LocalDateTime ld) {
        if (ld != null) {
            return Utils.localDateTimeToString(ld, DATE_FORMAT_DD_MM_YYYY_HH_MM_SS);
        }
        return null;
    }

    public static String localDateTimeToString(LocalDateTime ld, String pattern) {
        if (ld != null) {
            return DateTimeFormatter.ofPattern(pattern).format(ld);
        }
        return null;
    }

    public static LocalDateTime dateToLocalDateTime(java.util.Date date) {
        LocalDateTime ldt = null;
        if (date != null) {
            if (date instanceof Date) {
                Date sqlDate = (Date)date;
                ldt = LocalDateTime.of(sqlDate.toLocalDate(), LocalTime.of(0, 0));
            } else {
                ldt = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
        }
        if (ldt != null && ldt.getYear() < 1900) {
            ldt = Utils.cnvString2LocalDateTime(Utils.formatDate(date, DATE_FORMAT_DD_MM_YYYY_HH_MM_SS));
        }
        return ldt;
    }

    public static LocalDateTime cnvString2LocalDateTime(String value) {
        return Utils.cnvString2LocalDateTime(value, DATE_FORMAT_DD_MM_YYYY_HH_MM_SS);
    }

    public static LocalDateTime cnvString2LocalDateTime(String value, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(value, formatter);
    }

    public static java.util.Date localDateTimeToDate(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        if (ldt.getYear() < 1900) {
            return Utils.parseDate(Utils.formatLocalDateTime(ldt), DATE_FORMAT_DD_MM_YYYY_HH_MM_SS, true);
        }
        return java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_DD_MM_YYYY_HH_MM_SS);
        return localDateTime.format(formatter);
    }

    private static String formatDate(java.util.Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static java.util.Date parseDate(String s, String formatString, boolean throwException) {
        if (Utils.isEmpty(s)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(formatString);
        df.setLenient(false);
        try {
            java.util.Date result = df.parse(s);
            return result;
        }
        catch (ParseException ex) {
            if (throwException) {
                throw new IllegalArgumentException("'" + s + "' cannot be parsed to Date with format '" + formatString + "'");
            }
            return null;
        }
    }

    public static Map<String, Object> xmlToMap(String xml) {
        try {
            org.w3c.dom.Document doc = Utils.getDocumentFromInputString(xml);
            HashMap<String, Object> map = new HashMap<String, Object>();
            Utils.nodeToMap(doc.getDocumentElement(), map);
            return map;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void nodeToMap(Node node, Map<String, Object> map) {
        String name = node.getNodeName();
        String content = node.getTextContent();
        List<Node> childNodes = Utils.getChildNodes(node);
        if (!childNodes.isEmpty() || !Utils.isEmpty(content)) {
            if (childNodes.isEmpty()) {
                map.put(name, content);
            } else {
                ArrayList listForTag = (ArrayList)map.get(name);
                if (listForTag == null) {
                    listForTag = new ArrayList();
                    map.put(name, listForTag);
                }
                HashMap subMap = new HashMap();
                listForTag.add(subMap);
                childNodes.forEach(c -> Utils.nodeToMap(c, subMap));
            }
        }
    }

    private static List<Node> getChildNodes(Node rootNode) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nl = rootNode.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            Node n = nl.item(x);
            if (!Utils.isRelevantNode(n)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    private static boolean isRelevantNode(Node n) {
        return 1 == n.getNodeType();
    }

    public static org.w3c.dom.Document getDocumentFromInputString(String xml) throws Exception {
        Charset charset = Utils.getCharsetFromXml(xml);
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] bytes = xml.getBytes(charset);
        return Utils.getDocumentFromInputStream(() -> new ByteArrayInputStream(bytes));
    }

    private static Charset getCharsetFromXml(String xml) {
        try {
            XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
            String charsetStr = xmlStreamReader.getCharacterEncodingScheme();
            return Utils.isEmpty(charsetStr) ? null : Charset.forName(charsetStr);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static org.w3c.dom.Document getDocumentFromInputStream(Supplier<InputStream> isSupplier) throws Exception {
        try (InputStream is2 = isSupplier.get();){
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = dBuilder.parse(is2);
            doc.getDocumentElement().normalize();
            org.w3c.dom.Document document = doc;
            return document;
        }
    }

    public static String map2xml(Map<?, ?> map, boolean addType) {
        Document document = new Document();
        Element root = new Element("Map");
        Utils.map2xml(map, root, addType);
        document.setContent((Content)root);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(document);
    }

    private static void map2xml(Map<?, ?> map, Element parent, boolean addType) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                for (Object colValue : col) {
                    Utils.addChildNode(parent, key, colValue, addType);
                }
                continue;
            }
            Utils.addChildNode(parent, key, value, addType);
        }
    }

    private static void addChildNode(Element parent, Object key, Object value, boolean addType) {
        if (value != null) {
            Element child = new Element(key.toString());
            if (value instanceof Map) {
                Utils.map2xml((Map)value, child, addType);
                if (!child.getChildren().isEmpty()) {
                    parent.addContent((Content)child);
                }
            } else {
                String textValue = value.toString();
                if (value instanceof java.util.Date) {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_DD_MM_YYYY_HH_MM_SS);
                    textValue = df.format(value);
                } else if (value instanceof LocalDate) {
                    LocalDate lD = (LocalDate)value;
                    textValue = lD.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DD_MM_YYYY));
                } else if (value instanceof LocalDateTime) {
                    LocalDateTime lDT = (LocalDateTime)value;
                    textValue = lDT.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DD_MM_YYYY_HH_MM_SS));
                } else if (value instanceof LocalTime) {
                    LocalTime lT = (LocalTime)value;
                    textValue = lT.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                }
                if (addType) {
                    child.setAttribute("type", value.getClass().getName());
                }
                child.setText(textValue);
                parent.addContent((Content)child);
            }
        }
    }

    public static String formatXml(String xml) {
        String string;
        if (Utils.isEmpty(xml)) {
            return null;
        }
        StringWriter writer = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(new DOMSource(Utils.getDocumentFromInputString(xml)), result);
            String xmlFormatted = writer.toString();
            if (xml.startsWith("<?xml")) {
                xmlFormatted = xml.substring(0, xml.indexOf("?>") + 2) + "\r\n" + xmlFormatted;
            }
            if (xmlFormatted.endsWith("\r\n") && !xml.endsWith("\r\n")) {
                xmlFormatted = xmlFormatted.substring(0, xmlFormatted.length() - 2);
            }
            string = xmlFormatted;
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                Utils.safeClose(writer);
                throw throwable;
            }
        }
        Utils.safeClose(writer);
        return string;
    }

    public static String formatJSON(String json, boolean failOnParseError) {
        if (Utils.isEmpty(json)) {
            return json;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Object jsonObject = objectMapper.readValue(json, Object.class);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (JsonParseException ex) {
            if (failOnParseError) {
                throw new IllegalArgumentException(json, ex);
            }
            return json;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(json, ex);
        }
    }

    public static String object2Json(Object o) throws JsonProcessingException {
        return Utils.object2Json(o, true);
    }

    public static String object2Json(Object o, boolean withoutNullValues) throws JsonProcessingException {
        if (o == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        if (withoutNullValues) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return mapper.writeValueAsString(o);
    }

    public static String removeFromStringStart(String str, String strToRemove) {
        if (str != null && strToRemove != null && str.startsWith(strToRemove)) {
            str = str.length() > strToRemove.length() ? str.substring(strToRemove.length()) : "";
        }
        return str;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOfEntries(AbstractMap.SimpleEntry<K, V> ... values) {
        return Stream.of(values).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> AbstractMap.SimpleEntry<K, V> mapEntry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static boolean mapContainsMap(Map<?, ?> mapBase, Map<?, ?> mapCheckIfContains) {
        mapBase = Utils.nvlMap(mapBase);
        mapCheckIfContains = Utils.nvlMap(mapCheckIfContains);
        for (Map.Entry<?, ?> entryCheckIfContains : mapCheckIfContains.entrySet()) {
            if (mapBase.containsKey(entryCheckIfContains.getKey()) && Objects.equals(mapBase.get(entryCheckIfContains.getKey()), entryCheckIfContains.getValue())) continue;
            return false;
        }
        return true;
    }

    public static String getSystemProperty(String prop) {
        String value = System.getProperty(prop);
        if (value == null) {
            value = System.getenv(prop);
        }
        return value;
    }
}

