/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MockServicesUtil {
    public static boolean stringContainsString(String stack, String needle) {
        char[] needleChars = needle.toCharArray();
        int lastPosition = -1;
        for (char needleChar : needleChars) {
            if ((lastPosition = stack.indexOf(needleChar, lastPosition + 1)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean xmlContainsXml(String stack, String needle) {
        Map mapStack = Utils.xmlToMap((String)stack);
        Map mapNeedle = Utils.xmlToMap((String)needle);
        return MockServicesUtil.mapContainsMap(mapStack, mapNeedle);
    }

    public static boolean jsonContainsJson(String stack, String needle) {
        Map<String, Object> mapStack = MockServicesUtil.jsonToMap(stack);
        Map<String, Object> mapNeedle = MockServicesUtil.jsonToMap(needle);
        return MockServicesUtil.mapContainsMap(mapStack, mapNeedle);
    }

    private static Map<String, Object> jsonToMap(String jason) {
        try {
            Map result = (Map)new ObjectMapper().readValue(jason, HashMap.class);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static boolean mapContainsMap(Map<String, Object> stack, Map<String, Object> needle) {
        for (Map<String, Object> stackMap : MockServicesUtil.getAllMapsInMap(stack)) {
            boolean containsAll = true;
            for (Map.Entry<String, Object> entry : needle.entrySet()) {
                String needleKey = entry.getKey();
                Object needleValue = entry.getValue();
                if (!stackMap.containsKey(needleKey)) {
                    containsAll = false;
                    break;
                }
                if (needleValue instanceof List) {
                    if (MockServicesUtil.stackContainsNeedleList(stackMap, needleKey, needleValue)) continue;
                    containsAll = false;
                    break;
                }
                if (needleValue instanceof Map) {
                    if (MockServicesUtil.stackContainsNeedleMap(stackMap, needleKey, needleValue)) continue;
                    containsAll = false;
                    break;
                }
                if (Objects.equals(needleValue, stackMap.get(needleKey))) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) continue;
            return true;
        }
        return false;
    }

    private static List<Map<String, Object>> getAllMapsInMap(Map<String, Object> rootMap) {
        ArrayList<Map<String, Object>> allMaps = new ArrayList<Map<String, Object>>();
        allMaps.add(rootMap);
        allMaps.addAll(MockServicesUtil.getAllMapsInCollection(rootMap.values()));
        return allMaps;
    }

    private static List<Map<String, Object>> getAllMapsInCollection(Collection<Object> rootCol) {
        ArrayList<Map<String, Object>> allMaps = new ArrayList<Map<String, Object>>();
        for (Object obj : rootCol) {
            if (obj instanceof Map) {
                allMaps.addAll(MockServicesUtil.getAllMapsInMap((Map)obj));
                continue;
            }
            if (!(obj instanceof Collection)) continue;
            allMaps.addAll(MockServicesUtil.getAllMapsInCollection((Collection)obj));
        }
        return allMaps;
    }

    private static boolean stackContainsNeedleMap(Map<String, Object> stack, String needleKey, Object needleValue) {
        Object stackValue = stack.get(needleKey);
        if (!(stackValue instanceof Map)) {
            return false;
        }
        Map mapStack = (Map)stackValue;
        Map mapNeedle = (Map)needleValue;
        return MockServicesUtil.mapContainsMap(mapStack, mapNeedle);
    }

    private static boolean stackContainsNeedleList(Map<String, Object> stack, String needleKey, Object needleValue) {
        Object stackValue = stack.get(needleKey);
        if (!(stackValue instanceof List)) {
            return false;
        }
        List needleList = (List)needleValue;
        ArrayList stackList = (ArrayList)stackValue;
        stackList = new ArrayList(stackList);
        for (Map mapOfNeedleList : needleList) {
            Map mapOfStackListMatching = null;
            for (Map mapOfStackList : stackList) {
                if (!MockServicesUtil.mapContainsMap(mapOfStackList, mapOfNeedleList)) continue;
                mapOfStackListMatching = mapOfStackList;
                break;
            }
            if (mapOfStackListMatching == null) {
                return false;
            }
            stackList.remove(mapOfStackListMatching);
        }
        return true;
    }

    public static String getUrlWithReplacedDynVars(String url) {
        if (url != null) {
            int idxBracket = ((String)url).indexOf("{");
            while (idxBracket >= 0) {
                url = ((String)url).substring(0, idxBracket) + "%" + ((String)url).substring(((String)url).indexOf("}"));
                url = ((String)url).replaceFirst("}", "");
                idxBracket = ((String)url).indexOf("{");
            }
        }
        return url;
    }
}

