/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.util;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.shared.Utils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HttpRouting {
    public static Response doRouting(String endpoint, String endpointCalled, String request, HttpMethod httpMethod, MultivaluedMap<String, String> headerMap, boolean isSOAP, boolean isInternalRouting) {
        Response response;
        ByteArrayOutputStream outputStreamRequest = null;
        OutputStream httpOutRequest = null;
        InputStream inputStreamResponse = null;
        InputStreamReader inputStreamReaderResponse = null;
        BufferedReader bufReaderResponse = null;
        try {
            boolean isWsdlRequest = isSOAP && endpoint.endsWith("?wsdl");
            HttpURLConnection httpConn = (HttpURLConnection)new URL(endpoint).openConnection();
            HttpRouting.transferHeaderData(headerMap, httpConn, isInternalRouting);
            if (isWsdlRequest) {
                httpConn.setRequestMethod(HttpMethod.GET.name());
                httpConn.setDoOutput(true);
            } else {
                byte[] bytesRequest = null;
                httpConn.setRequestMethod(httpMethod.name());
                httpConn.setDoOutput(true);
                if (!Utils.isEmpty((String)request)) {
                    httpConn.setDoInput(true);
                    outputStreamRequest = new ByteArrayOutputStream();
                    outputStreamRequest.write(request.getBytes(HttpRouting.getCharset(HttpRouting.getCharsetFromHeaders(headerMap))));
                    bytesRequest = outputStreamRequest.toByteArray();
                    httpOutRequest = httpConn.getOutputStream();
                    httpOutRequest.write(bytesRequest);
                }
            }
            try {
                inputStreamResponse = httpConn.getInputStream();
            }
            catch (IOException ioEx) {
                inputStreamResponse = httpConn.getErrorStream();
            }
            StringBuilder buiResponse = new StringBuilder();
            if (inputStreamResponse != null) {
                inputStreamReaderResponse = new InputStreamReader(inputStreamResponse, HttpRouting.getCharset(HttpRouting.getCharsetFromHeaders(httpConn.getHeaderFields())));
                bufReaderResponse = new BufferedReader(inputStreamReaderResponse);
                String responseString = "";
                while ((responseString = bufReaderResponse.readLine()) != null) {
                    buiResponse.append(responseString);
                }
            }
            response = HttpRouting.buildResponse(endpoint, endpointCalled, isWsdlRequest, httpConn, buiResponse);
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                Utils.safeClose((Closeable[])new Closeable[]{outputStreamRequest, httpOutRequest, inputStreamResponse, inputStreamReaderResponse, bufReaderResponse});
                throw throwable;
            }
        }
        Utils.safeClose((Closeable[])new Closeable[]{outputStreamRequest, httpOutRequest, inputStreamResponse, inputStreamReaderResponse, bufReaderResponse});
        return response;
    }

    private static Response buildResponse(String endpoint, String endpointCalled, boolean isWsdlRequest, HttpURLConnection httpConn, StringBuilder buiResponse) throws IOException {
        String response = buiResponse.toString();
        if (isWsdlRequest) {
            response = response.replace(endpoint.substring(0, endpoint.length() - "?wsdl".length()), endpointCalled.replace("?wsdl", ""));
        }
        Response.ResponseBuilder responseBui = Response.status((int)httpConn.getResponseCode());
        if (!Utils.isEmpty((String)response)) {
            responseBui = responseBui.entity((Object)response);
        }
        for (Map.Entry headerEntry : Utils.nvlMap(httpConn.getHeaderFields()).entrySet()) {
            Optional<String> headerValueOpt = Utils.nvlCollection((Collection)((Collection)headerEntry.getValue())).stream().filter(v -> v != null).findFirst();
            if (!headerValueOpt.isPresent()) continue;
            responseBui = responseBui.header((String)headerEntry.getKey(), (Object)headerValueOpt.get());
        }
        return responseBui.build();
    }

    private static void transferHeaderData(MultivaluedMap<String, String> headerMap, HttpURLConnection httpConn, boolean isInternalRouting) {
        for (String headerKey : headerMap.keySet()) {
            if (!isInternalRouting && ("HTTP_HEADER_MOCK_PROFILE_NAME".equals(headerKey) || "HTTP_HEADER_RECORD_SESSION_ID".equals(headerKey) || "HTTP_HEADER_TENANT_ID".equals(headerKey))) continue;
            List headerValues = (List)headerMap.get((Object)headerKey);
            if (Utils.isCollectionEmpty((Collection)headerValues)) {
                httpConn.addRequestProperty(headerKey, null);
                continue;
            }
            for (String headerValue : headerValues) {
                httpConn.addRequestProperty(headerKey, headerValue);
            }
        }
    }

    static String getCharsetFromHeaders(Map<String, ? extends Object> headers) {
        for (String headerKey : headers.keySet()) {
            Object value;
            if ("charset".equalsIgnoreCase(headerKey)) {
                value = headers.get(headerKey);
                if (value instanceof String) {
                    return (String)value;
                }
                if (!(value instanceof Collection)) continue;
                for (Object valueElement : (Collection)value) {
                    if (!(valueElement instanceof String)) continue;
                    return (String)valueElement;
                }
                continue;
            }
            if (!"Content-Type".equalsIgnoreCase(headerKey)) continue;
            value = headers.get(headerKey);
            String valueStr = null;
            if (value instanceof String) {
                valueStr = (String)value;
            } else if (value instanceof Collection) {
                for (Object valueElement : (Collection)value) {
                    if (!(valueElement instanceof String)) continue;
                    valueStr = (String)valueElement;
                }
            }
            if (Utils.isEmpty((String)valueStr)) continue;
            for (String valuePart : valueStr.split(";")) {
                valuePart = valuePart.replace("[", "").replace("]", "");
                if (!(valuePart = valuePart.trim()).startsWith("charset=")) continue;
                return valuePart.split("=")[1];
            }
        }
        return null;
    }

    private static Charset getCharset(String charset) {
        if (Utils.isEmpty((String)charset)) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charset);
        }
        catch (Exception ex) {
            return StandardCharsets.UTF_8;
        }
    }
}

