/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.model;

import de.joergdev.mosy.backend.persistence.model.MockDataMockProfile;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.persistence.model.TenantScoped;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity
@Table(name="MOCK_PROFILE")
public class MockProfile
implements TenantScoped {
    public static final int LENGTH_NAME = 200;
    public static final int LENGTH_DESCRIPTION = 2000;
    @Column(name="MOCK_PROFILE_ID")
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer mockProfileID;
    @ManyToOne
    @JoinColumn(name="TENANT_ID", nullable=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Tenant tenant;
    @Column(name="CREATED")
    private LocalDateTime created;
    @Column(name="NAME", length=200, nullable=true)
    private String name;
    @Column(name="PERSISTENT", length=1, nullable=false, columnDefinition="INTEGER")
    private Boolean persistent;
    @Column(name="USE_COMMON_MOCKS", length=1, nullable=false, columnDefinition="INTEGER")
    private Boolean useCommonMocks;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @OneToMany(mappedBy="mockProfile", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MockDataMockProfile> mockData;

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public Integer getMockProfileID() {
        return this.mockProfileID;
    }

    public void setMockProfileID(Integer mockProfileID) {
        this.mockProfileID = mockProfileID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public Boolean getUseCommonMocks() {
        return this.useCommonMocks;
    }

    public void setUseCommonMocks(Boolean useCommonMocks) {
        this.useCommonMocks = useCommonMocks;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MockDataMockProfile> getMockData() {
        return this.mockData;
    }

    public void setMockData(List<MockDataMockProfile> mockData) {
        this.mockData = mockData;
    }

    @Override
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }
}

