/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class TenantDao
extends AbstractDAO {
    public List<Tenant> getAll() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from TENANT ");
        sql.append(" where NAME != :dummy_name_non_multi_tanency ");
        sql.append(" order by NAME ");
        Query q = this.entityMgr.createNativeQuery(sql.toString(), Tenant.class);
        q.setParameter("dummy_name_non_multi_tanency", (Object)"Default non-multi-tanency");
        return q.getResultList();
    }

    public boolean existsByName(String name, Integer exceptID) {
        return this.getByName(name, exceptID) != null;
    }

    public Tenant getByName(String name, Integer exceptID) {
        Objects.requireNonNull(name, "name");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from TENANT ");
        sql.append(" where name = :name ");
        if (exceptID != null) {
            sql.append(" and tenant_id != :id ");
            params.put("id", exceptID);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), Tenant.class);
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        return (Tenant)this.getSingleResult(q);
    }
}

