/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.persistence.model.Record;
import de.joergdev.mosy.shared.Utils;
import jakarta.persistence.Query;
import java.util.List;

public class RecordDAO
extends AbstractDAO {
    public List<Record> getAll(Integer loadCount, Integer lastLoadedId, Integer recordSessionID) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from record r ");
        sql.append(" where tenant_id = :tenant_id ");
        if (recordSessionID != null) {
            sql.append(" and r.RECORD_SESSION_ID = :rs_id ");
        }
        if (loadCount != null || lastLoadedId != null) {
            sql.append(" and ");
            sql.append(" r.record_id in ( ");
            sql.append("    select r2.record_id from record r2 ");
            if (lastLoadedId != null) {
                sql.append("  where r2.record_id < :last_load_id ");
            }
            sql.append("    order by r2.record_id desc ");
            sql.append(" ) ");
            if (loadCount != null) {
                sql.append(" and ROWNUM() <= :load_count ");
            }
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), Record.class);
        q.setParameter("tenant_id", (Object)this.tenantId);
        if (recordSessionID != null) {
            q.setParameter("rs_id", (Object)recordSessionID);
        }
        if (lastLoadedId != null) {
            q.setParameter("last_load_id", (Object)lastLoadedId);
        }
        if (loadCount != null) {
            q.setParameter("load_count", (Object)loadCount);
        }
        return q.getResultList();
    }

    public int getCount() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(record_id) from record ");
        sql.append(" where tenant_id = :tenant_id ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("tenant_id", (Object)this.tenantId);
        return Utils.numberToInteger((Number)((Number)this.getSingleResult(q)));
    }

    public void deleteAll() {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from record ");
        sql.append(" where tenant_id = :tenant_id ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("tenant_id", (Object)this.tenantId);
        this.executeUpdate(q);
    }
}

