/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.persistence.model.InterfaceMethod;
import de.joergdev.mosy.shared.Utils;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class InterfaceMethodDAO
extends AbstractDAO {
    public void increaseCountCalls(Integer id) {
        Objects.requireNonNull(id, "id");
        StringBuilder sql = new StringBuilder();
        sql.append(" update interface_method set COUNT_CALLS = COUNT_CALLS+1 where interface_method_id = :id ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("id", (Object)id);
        this.executeUpdate(q);
    }

    public void setValuesOnStartup() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append(" update interface_method set MOCK_ACTIVE = MOCK_ACTIVE_ON_STARTUP, COUNT_CALLS = 0 ");
        if (this.tenantId != null) {
            sql.append(" where tenant_id = :tenant_id ");
            params.put("tenant_id", this.tenantId);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        this.executeUpdate(q);
    }

    public Boolean isRecordEnabled(Integer id) {
        Objects.requireNonNull(id, "id");
        StringBuilder sql = new StringBuilder();
        sql.append(" select rc.enabled from RECORD_CONFIG rc ");
        sql.append(" where rc.INTERFACE_METHOD_ID = :id ");
        sql.append(" and rc.INTERFACE_ID is null and rc.REQUEST_DATA is null ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("id", (Object)id);
        List resultList = q.getResultList();
        return Utils.isCollectionEmpty((Collection)resultList) ? null : Boolean.valueOf(Integer.valueOf(1).equals(Utils.getFirstElementOfCollection((Collection)resultList)));
    }

    public InterfaceMethod getByServicePath(Integer interfaceId, String servicePath, boolean nonStrictSearchServicePath, HttpMethod httpMethod) {
        Objects.requireNonNull(servicePath, "servicePath");
        return this.getBySearchParams(interfaceId, null, servicePath, nonStrictSearchServicePath, httpMethod, null);
    }

    public boolean existsByInterfaceIdServicePath(Integer interfaceId, String servicePath, boolean nonStrictSearchServicePath, HttpMethod httpMethod, Integer exceptID) {
        Objects.requireNonNull(servicePath, "servicePath");
        return this.getBySearchParams(interfaceId, null, servicePath, nonStrictSearchServicePath, httpMethod, exceptID) != null;
    }

    public boolean existsByInterfaceIdName(Integer interfaceId, String name, Integer exceptID) {
        Objects.requireNonNull(name, "name");
        return this.getBySearchParams(interfaceId, name, null, false, null, exceptID) != null;
    }

    public InterfaceMethod getBySearchParams(Integer interfaceId, String name, String servicePath, boolean nonStrictSearchServicePath, HttpMethod httpMethod, Integer exceptID) {
        Objects.requireNonNull(interfaceId, "interfaceId");
        if (name == null && servicePath == null) {
            throw new IllegalArgumentException("no search param");
        }
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("i_id", interfaceId);
        sql.append(" select * from INTERFACE_METHOD ");
        sql.append(" where interface_id = :i_id ");
        if (name != null) {
            sql.append(" and name = :name ");
            params.put("name", name);
        }
        if (servicePath != null) {
            sql.append(" and :svc_path like SERVICE_PATH_INTERN ");
            params.put("svc_path", servicePath);
        }
        if (httpMethod != null) {
            sql.append(" and HTTP_METHOD = :http_method ");
            params.put("http_method", httpMethod.name());
        }
        if (exceptID != null) {
            sql.append(" and interface_method_id != :id ");
            params.put("id", exceptID);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), InterfaceMethod.class);
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        if (Utils.isEmpty((String)servicePath)) {
            return (InterfaceMethod)this.getSingleResult(q);
        }
        List methodsFound = this.getResultList(q);
        int cntPartsSvcPath = servicePath.split("/").length;
        InterfaceMethod methodFound = null;
        int cntPartsSvcPathMethodFound = -1;
        for (InterfaceMethod dbMethod : methodsFound) {
            int cntPartsSvcPathDbMethod = dbMethod.getServicePathIntern().split("/").length;
            if (nonStrictSearchServicePath) {
                if (cntPartsSvcPathDbMethod <= cntPartsSvcPathMethodFound) continue;
                methodFound = dbMethod;
                cntPartsSvcPathMethodFound = cntPartsSvcPathDbMethod;
                continue;
            }
            if (cntPartsSvcPathDbMethod != cntPartsSvcPath) continue;
            return dbMethod;
        }
        return methodFound;
    }
}

