/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.persistence.model.Interface;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class InterfaceDao
extends AbstractDAO {
    public List<Interface> getAll() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from INTERFACE  ");
        sql.append(" where tenant_id = :tenant_id ");
        sql.append(" order by INTERFACE_TYPE_ID, NAME ");
        Query q = this.entityMgr.createNativeQuery(sql.toString(), Interface.class);
        q.setParameter("tenant_id", (Object)this.tenantId);
        return q.getResultList();
    }

    public void setValuesOnStartup() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append(" update interface set MOCK_ACTIVE = MOCK_ACTIVE_ON_STARTUP ");
        if (this.tenantId != null) {
            sql.append(" where tenant_id = :tenant_id ");
            params.put("tenant_id", this.tenantId);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        this.executeUpdate(q);
    }

    public Interface getByServicePath(String servicePath, boolean servicePathStartsWith) {
        Objects.requireNonNull(servicePath, "servicePath");
        return this.getBySearchParams(null, servicePath, servicePathStartsWith, null);
    }

    public Interface getByName(String name) {
        Objects.requireNonNull(name, "name");
        return this.getBySearchParams(name, null, false, null);
    }

    public boolean existsByServicePath(String servicePath, boolean servicePathStartsWith, Integer exceptID) {
        Objects.requireNonNull(servicePath, "servicePath");
        return this.getBySearchParams(null, servicePath, servicePathStartsWith, exceptID) != null;
    }

    public boolean existsByName(String name, Integer exceptID) {
        Objects.requireNonNull(name, "name");
        return this.getBySearchParams(name, null, false, exceptID) != null;
    }

    public Interface getBySearchParams(String name, String servicePath, boolean servicePathStartsWith, Integer exceptID) {
        if (name == null && servicePath == null) {
            throw new IllegalArgumentException("no search param");
        }
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append(" select * from INTERFACE ");
        sql.append(" where tenant_id = :tenant_id ");
        params.put("tenant_id", this.tenantId);
        if (name != null) {
            sql.append(" and name = :name ");
            params.put("name", name);
        }
        if (servicePath != null) {
            sql.append(" and ");
            if (servicePathStartsWith) {
                sql.append(" (:svc_path like SERVICE_PATH || '%' or SERVICE_PATH || '%' like :svc_path) ");
            } else {
                sql.append(" SERVICE_PATH = :svc_path ");
            }
            params.put("svc_path", servicePath);
        }
        if (exceptID != null) {
            sql.append(" and interface_id != :id ");
            params.put("id", exceptID);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), Interface.class);
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        return (Interface)this.getSingleResult(q);
    }
}

