/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.utils;

import de.joergdev.mosy.api.response.AbstractResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.backend.Config;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.TenantDao;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.persistence.model.TenantScoped;
import de.joergdev.mosy.backend.security.TokenManagerService;
import de.joergdev.mosy.shared.Utils;
import jakarta.ws.rs.core.MultivaluedMap;

public class TenancyUtils {
    public static Integer getDefaultTenantIdForNonMultiTanency(AbstractBL<?, ? extends AbstractResponse> bl) {
        return bl.getDao(TenantDao.class).getByName("Default non-multi-tanency", null).getTenantId();
    }

    public static void setInternTokenForTenancy(AbstractBL<?, ? extends AbstractResponse> bl, MultivaluedMap<String, String> requestHeader) {
        Integer tenantId = null;
        if (Config.isMultiTenancyEnabled()) {
            String tenantIdHeader = (String)requestHeader.getFirst((Object)"HTTP_HEADER_TENANT_ID");
            bl.leaveOn(!Utils.isNumeric((String)tenantIdHeader), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request header - tenantId (" + tenantIdHeader + ")"));
            tenantId = Integer.valueOf(tenantIdHeader);
        }
        TenancyUtils.setInternTokenForTenancy(bl, tenantId);
    }

    public static void setInternTokenForTenancy(AbstractBL<?, ? extends AbstractResponse> bl, Integer tenantId) {
        if (bl.getToken() != null) {
            return;
        }
        String token = TokenManagerService.createTokenWithoutSecretCheck(tenantId, () -> TenancyUtils.getDefaultTenantIdForNonMultiTanency(bl));
        bl.setToken(token);
    }

    public static <L> L checkTenantAccessForDbEntity(L entity, Integer tenantId) {
        if (tenantId != null) {
            Tenant entityTenant = null;
            boolean checkTenant = false;
            if (entity instanceof TenantScoped) {
                entityTenant = ((TenantScoped)entity).getTenant();
                checkTenant = entityTenant != null;
            } else if (entity instanceof Tenant) {
                entityTenant = (Tenant)entity;
                boolean bl = checkTenant = entityTenant.getTenantId() != null;
            }
            if (checkTenant && !tenantId.equals(entityTenant.getTenantId())) {
                throw new IllegalStateException("Access denied - tenantId: " + tenantId + " - entityTenandId: " + entityTenant.getTenantId());
            }
        }
        return entity;
    }
}

