/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.tenant;

import de.joergdev.mosy.api.response.tenant.LoadAllResponse;
import de.joergdev.mosy.backend.Config;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.TenantDao;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadAll
extends AbstractBL<Void, LoadAllResponse> {
    private final List<de.joergdev.mosy.api.model.Tenant> apiTenants = new ArrayList<de.joergdev.mosy.api.model.Tenant>();

    @Override
    protected void beforeExecute() {
        this.checkToken = false;
    }

    @Override
    protected void validateInput() {
    }

    @Override
    protected void execute() {
        if (!Config.isMultiTenancyEnabled()) {
            return;
        }
        List<Tenant> dbTenants = this.getDao(TenantDao.class).getAll();
        for (Tenant dbTenant : Utils.nvlCollection(dbTenants)) {
            de.joergdev.mosy.api.model.Tenant apiTenant = new de.joergdev.mosy.api.model.Tenant();
            ObjectUtils.copyValues((Object)dbTenant, (Object)apiTenant, (String[])new String[0]);
            this.apiTenants.add(apiTenant);
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadAllResponse)this.response).setMultiTanencyEnabled(Config.isMultiTenancyEnabled());
        ((LoadAllResponse)this.response).getTenants().addAll(this.apiTenants);
    }
}

