/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.record;

import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.RecordSession;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.record.LoadAllResponse;
import de.joergdev.mosy.backend.api.intern.request.record.LoadAllRequest;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.RecordDAO;
import de.joergdev.mosy.backend.persistence.model.Record;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadAll
extends AbstractBL<LoadAllRequest, LoadAllResponse> {
    private final List<de.joergdev.mosy.api.model.Record> apiRecords = new ArrayList<de.joergdev.mosy.api.model.Record>();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        InterfaceMethod interfaceMethod = ((LoadAllRequest)this.request).getInterfaceMethod();
        if (interfaceMethod != null) {
            this.leaveOn(interfaceMethod.getInterfaceMethodId() == null || !Utils.isPositive((Number)interfaceMethod.getInterfaceMethodId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method id"));
            this.leaveOn(interfaceMethod.getMockInterface() != null && interfaceMethod.getMockInterface().getInterfaceId() != null && !Utils.isPositive((Number)interfaceMethod.getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interfaceId"));
            this.leaveOn(((LoadAllRequest)this.request).getLoadCount() != null || ((LoadAllRequest)this.request).getRecordSessionID() != null, ResponseCode.OPERATION_NOT_POSSIBLE.withAddtitionalInfo("load by method, filtering not supported"));
        }
        this.leaveOn(((LoadAllRequest)this.request).getLoadCount() != null && ((LoadAllRequest)this.request).getLoadCount() <= 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("loadCount"));
        this.leaveOn(((LoadAllRequest)this.request).getLastLoadedId() != null && !Utils.isPositive((Number)((LoadAllRequest)this.request).getLastLoadedId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("lastLoadedId"));
        this.leaveOn(((LoadAllRequest)this.request).getRecordSessionID() != null && !Utils.isPositive((Number)((LoadAllRequest)this.request).getRecordSessionID()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("recordSessionID"));
    }

    @Override
    protected void execute() {
        List<Record> dbRecords = null;
        if (((LoadAllRequest)this.request).getInterfaceMethod() != null) {
            de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.InterfaceMethod.class, ((LoadAllRequest)this.request).getInterfaceMethod().getInterfaceMethodId(), "interface method with id " + ((LoadAllRequest)this.request).getInterfaceMethod().getInterfaceMethodId());
            this.checkInterface(dbMethod);
            dbRecords = dbMethod.getRecords();
        } else {
            dbRecords = this.getDao(RecordDAO.class).getAll(((LoadAllRequest)this.request).getLoadCount(), ((LoadAllRequest)this.request).getLastLoadedId(), ((LoadAllRequest)this.request).getRecordSessionID());
        }
        for (Record dbRecord : Utils.nvlCollection(dbRecords)) {
            de.joergdev.mosy.api.model.Record apiRecord = new de.joergdev.mosy.api.model.Record();
            ObjectUtils.copyValues((Object)dbRecord, (Object)apiRecord, (String[])new String[]{"requestData", "response", "created", "interfaceMethod", "recordSession"});
            apiRecord.setCreatedAsLdt(dbRecord.getCreated());
            de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = dbRecord.getInterfaceMethod();
            de.joergdev.mosy.backend.persistence.model.Interface dbInterface = dbMethod.getMockInterface();
            InterfaceMethod apiMethod = new InterfaceMethod();
            apiMethod.setInterfaceMethodId(dbMethod.getInterfaceMethodId());
            apiMethod.setName(dbMethod.getName());
            Interface apiInterface = new Interface();
            apiInterface.setInterfaceId(dbInterface.getInterfaceId());
            apiInterface.setName(dbInterface.getName());
            apiMethod.setMockInterfaceData(apiInterface);
            apiRecord.setInterfaceMethod(apiMethod);
            this.apiRecords.add(apiRecord);
            if (dbRecord.getRecordSession() == null) continue;
            RecordSession apiRecordSession = new RecordSession();
            apiRecordSession.setRecordSessionID(dbRecord.getRecordSession().getRecordSessionID());
            apiRecordSession.setCreatedAsLdt(dbRecord.getRecordSession().getCreated());
            apiRecord.setRecordSession(apiRecordSession);
        }
    }

    private void checkInterface(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        Interface apiInterface = ((LoadAllRequest)this.request).getInterfaceMethod().getMockInterface();
        if (apiInterface != null) {
            Integer interfaceId = apiInterface.getInterfaceId();
            this.leaveOn(interfaceId != null && !interfaceId.equals(dbMethod.getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method with id " + ((LoadAllRequest)this.request).getInterfaceMethod().getInterfaceMethodId() + " not exisiting for interface with id " + interfaceId));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadAllResponse)this.response).getRecords().addAll(this.apiRecords);
    }
}

