/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.record;

import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.RecordSession;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.record.LoadResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.model.Record;
import de.joergdev.mosy.backend.persistence.model.RecordPathParam;
import de.joergdev.mosy.backend.persistence.model.RecordUrlArgument;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;

public class Load
extends AbstractBL<Integer, LoadResponse> {
    private final de.joergdev.mosy.api.model.Record apiRecord = new de.joergdev.mosy.api.model.Record();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null || !Utils.isPositive((Number)((Number)this.request)), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("id"));
    }

    @Override
    protected void execute() {
        Record dbRecord = this.findDbEntity(Record.class, this.request, "record with id " + String.valueOf(this.request));
        ObjectUtils.copyValues((Object)dbRecord, (Object)this.apiRecord, (String[])new String[]{"created", "interfaceMethod", "recordSession", "pathParams"});
        this.apiRecord.setCreatedAsLdt(dbRecord.getCreated());
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = dbRecord.getInterfaceMethod();
        de.joergdev.mosy.backend.persistence.model.Interface dbInterface = dbMethod.getMockInterface();
        InterfaceMethod apiMethod = new InterfaceMethod();
        apiMethod.setInterfaceMethodId(dbMethod.getInterfaceMethodId());
        apiMethod.setName(dbMethod.getName());
        Interface apiInterface = new Interface();
        apiInterface.setInterfaceId(dbInterface.getInterfaceId());
        apiInterface.setName(dbInterface.getName());
        apiMethod.setMockInterfaceData(apiInterface);
        this.apiRecord.setInterfaceMethod(apiMethod);
        if (dbRecord.getRecordSession() != null) {
            RecordSession apiRecordSession = new RecordSession();
            apiRecordSession.setRecordSessionID(dbRecord.getRecordSession().getRecordSessionID());
            apiRecordSession.setCreatedAsLdt(dbRecord.getRecordSession().getCreated());
            this.apiRecord.setRecordSession(apiRecordSession);
        }
        for (RecordPathParam dbPathParam : dbRecord.getPathParams()) {
            this.apiRecord.getPathParams().add(new PathParam(dbPathParam.getKey(), dbPathParam.getValue()));
        }
        for (RecordUrlArgument dbUrlArg : dbRecord.getUrlArguments()) {
            this.apiRecord.getUrlArguments().add(new UrlArgument(dbUrlArg.getKey(), dbUrlArg.getValue()));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadResponse)this.response).setRecord(this.apiRecord);
    }
}

