/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockservices;

import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.backend.api.intern.request.mockservices.CaptureCommonRequest;
import de.joergdev.mosy.backend.api.intern.request.mockservices.CaptureSoapRequest;
import de.joergdev.mosy.backend.api.intern.response.mockservices.CaptureCommonResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.mockservices.CaptureCommon;
import de.joergdev.mosy.shared.Utils;

public class CaptureSoap
extends AbstractBL<CaptureSoapRequest, CaptureCommonResponse> {
    @Override
    protected void beforeExecute() {
        this.checkToken = false;
    }

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(Utils.isEmpty((String)((CaptureSoapRequest)this.request).getPath()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("path"));
        this.leaveOn(!((CaptureSoapRequest)this.request).isWsdlRequest() && Utils.isEmpty((String)((CaptureSoapRequest)this.request).getContent()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("content"));
    }

    @Override
    protected void execute() {
        CaptureCommonRequest commonReq = new CaptureCommonRequest();
        commonReq.setServicePathInterface(((CaptureSoapRequest)this.request).getPath());
        commonReq.setServicePathMethod(this.getServicePathMethod());
        commonReq.setHttpHeaders(((CaptureSoapRequest)this.request).getHttpHeaders());
        commonReq.setContent(((CaptureSoapRequest)this.request).getContent());
        commonReq.setAbsolutePath(((CaptureSoapRequest)this.request).getAbsolutePath());
        if (((CaptureSoapRequest)this.request).isWsdlRequest()) {
            commonReq.setRouteOnly(true);
            commonReq.setRouteAddition("?wsdl");
        }
        this.invokeSubBL(new CaptureCommon(), commonReq, (CaptureCommonResponse)this.response);
    }

    private String getServicePathMethod() {
        int idxNamespace;
        if (Utils.isEmpty((String)((CaptureSoapRequest)this.request).getContent())) {
            return null;
        }
        String xmlContent = ((CaptureSoapRequest)this.request).getContent();
        int idxSoapBody = xmlContent.toLowerCase().indexOf(":body>");
        this.leaveOn(idxSoapBody < 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("no soap body"));
        int idxNextTag = xmlContent.indexOf("<", idxSoapBody + 1);
        this.leaveOn(idxNextTag < 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("no tag after soap body"));
        int idxNextTagEnd = xmlContent.indexOf(">", idxNextTag + 1);
        this.leaveOn(idxNextTag < 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("no tag end after soap body"));
        String nextTag = xmlContent.substring(idxNextTag + 1, idxNextTagEnd).trim();
        this.leaveOn(Utils.isEmpty((String)nextTag), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("first tag in soap body is empty"));
        int idxEndServicePath = (Integer)Utils.min((Comparable[])new Integer[]{nextTag.indexOf(" "), nextTag.indexOf("/")});
        if (idxEndServicePath > 0) {
            nextTag = nextTag.substring(0, idxEndServicePath);
        }
        if ((idxNamespace = nextTag.indexOf(":")) > 0) {
            nextTag = nextTag.substring(idxNamespace + 1);
        }
        return nextTag;
    }

    @Override
    protected void fillOutput() {
    }
}

