/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockservices;

import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.InterfaceType;
import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.Record;
import de.joergdev.mosy.api.model.RecordSession;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.record.SaveResponse;
import de.joergdev.mosy.api.response.system.LoadBaseDataResponse;
import de.joergdev.mosy.backend.api.intern.request.mockservices.CaptureCommonRequest;
import de.joergdev.mosy.backend.api.intern.response.mockservices.CaptureCommonResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.globalconfig.Load;
import de.joergdev.mosy.backend.bl.record.Save;
import de.joergdev.mosy.backend.bl.utils.PersistenceUtil;
import de.joergdev.mosy.backend.bl.utils.TenancyUtils;
import de.joergdev.mosy.backend.persistence.dao.InterfaceMethodDAO;
import de.joergdev.mosy.backend.persistence.dao.MockDataDAO;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.dao.RecordConfigDAO;
import de.joergdev.mosy.backend.persistence.model.Interface;
import de.joergdev.mosy.backend.persistence.model.MockData;
import de.joergdev.mosy.backend.persistence.model.MockDataPathParam;
import de.joergdev.mosy.backend.persistence.model.MockDataUrlArgument;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.backend.persistence.model.RecordConfig;
import de.joergdev.mosy.backend.util.HttpRouting;
import de.joergdev.mosy.backend.util.MockServicesUtil;
import de.joergdev.mosy.shared.Utils;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CaptureCommon
extends AbstractBL<CaptureCommonRequest, CaptureCommonResponse> {
    private MultivaluedMap<String, String> requestHeader;
    private String mockResponse;
    private Integer mockResponseHttpCode;
    private MultivaluedMap<String, Object> mockResponseHeaders;
    private de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod;

    @Override
    protected void beforeExecute() {
        this.checkToken = false;
    }

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(Utils.isEmpty((String)((CaptureCommonRequest)this.request).getServicePathInterface()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("servicepath interface"));
        this.requestHeader = ((CaptureCommonRequest)this.request).getHttpHeaders().getRequestHeaders();
        this.leaveOn(this.requestHeader == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request header"));
    }

    @Override
    protected void execute() {
        TenancyUtils.setInternTokenForTenancy(this, this.requestHeader);
        Interface dbInterface = PersistenceUtil.getDbInterfaceByServicePath(this, ((CaptureCommonRequest)this.request).getServicePathInterface(), false);
        InterfaceType interfaceType = InterfaceType.getById((Integer)dbInterface.getType().getInterfaceTypeId());
        this.leaveOn(!InterfaceType.REST.equals((Object)interfaceType) && !((CaptureCommonRequest)this.request).isRouteOnly() && Utils.isEmpty((String)((CaptureCommonRequest)this.request).getServicePathMethod()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("servicepath method"));
        this.dbMethod = PersistenceUtil.getDbInterfaceMethodByServicePath(this, ((CaptureCommonRequest)this.request).getServicePathMethod(), true, ((CaptureCommonRequest)this.request).getHttpMethod(), dbInterface, false);
        this.leaveOn(!InterfaceType.REST.equals((Object)interfaceType) && !((CaptureCommonRequest)this.request).isRouteOnly() && Utils.isEmpty((String)((CaptureCommonRequest)this.request).getContent()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("content"));
        this.checkMockProfile();
        this.checkRecordSession();
        BaseData baseData = this.invokeSubBL(new Load(), null, new LoadBaseDataResponse()).getBaseData();
        if (this.mockEnabled(dbInterface, this.dbMethod, baseData) && !((CaptureCommonRequest)this.request).isRouteOnly()) {
            this.tryMock(dbInterface, this.dbMethod, baseData, interfaceType);
        } else if (interfaceType.directRoutingPossible) {
            this.doRouting(((CaptureCommonRequest)this.request).getContent(), dbInterface, baseData, this.dbMethod, interfaceType);
        } else {
            ((CaptureCommonResponse)this.response).setRoute(true);
            ((CaptureCommonResponse)this.response).setRecord(this.recordRequestResponse(baseData, dbInterface, this.dbMethod, interfaceType));
        }
        if (this.dbMethod != null) {
            this.getDao(InterfaceMethodDAO.class).increaseCountCalls(this.dbMethod.getInterfaceMethodId());
        }
    }

    private void tryMock(Interface dbInterface, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, BaseData baseData, InterfaceType interfaceType) {
        MockData dbMockDataFound = this.getMockDataForRequest(dbMethod, interfaceType);
        if (dbMockDataFound == null) {
            if (this.routingOnNoMockData(dbInterface, dbMethod, baseData)) {
                if (interfaceType.directRoutingPossible) {
                    this.doRouting(((CaptureCommonRequest)this.request).getContent(), dbInterface, baseData, dbMethod, interfaceType);
                } else {
                    ((CaptureCommonResponse)this.response).setRoute(true);
                    ((CaptureCommonResponse)this.response).setRecord(this.recordRequestResponse(baseData, dbInterface, dbMethod, interfaceType));
                }
            } else {
                this.leaveOn(true, ResponseCode.OPERATION_FAILED_ERROR.withAddtitionalInfo("no mockdata for interface " + dbInterface.getName() + ", method " + dbMethod.getName() + ", request " + ((CaptureCommonRequest)this.request).getContent()));
            }
        } else {
            this.mockResponse = dbMockDataFound.getResponse();
            this.mockResponseHttpCode = dbMockDataFound.getHttpReturnCode();
            this.setMockResponseHeaders(interfaceType);
            this.getDao(MockDataDAO.class).increaseCountCalls(dbMockDataFound.getMockDataId());
            this.sleepOnDelaySet(dbMockDataFound);
        }
    }

    private void setMockResponseHeaders(InterfaceType interfaceType) {
        this.mockResponseHeaders = new MultivaluedHashMap();
        if (InterfaceType.REST.equals((Object)interfaceType)) {
            this.mockResponseHeaders.add((Object)"Content-Type", (Object)"application/json");
        } else if (InterfaceType.SOAP.equals((Object)interfaceType)) {
            this.mockResponseHeaders.add((Object)"Content-Type", (Object)"text/xml");
        }
    }

    private void sleepOnDelaySet(MockData dbMockDataFound) {
        if (dbMockDataFound.getDelay() != null) {
            try {
                Thread.sleep(dbMockDataFound.getDelay());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
    }

    private boolean routingOnNoMockData(Interface dbInterface, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, BaseData baseData) {
        if (Boolean.TRUE.equals(baseData.getRoutingOnNoMockData())) {
            return true;
        }
        if (Boolean.FALSE.equals(baseData.getRoutingOnNoMockData())) {
            return false;
        }
        if (Boolean.TRUE.equals(dbInterface.getRoutingOnNoMockData())) {
            return true;
        }
        if (Boolean.FALSE.equals(dbInterface.getRoutingOnNoMockData())) {
            return false;
        }
        return dbMethod != null && Boolean.TRUE.equals(dbMethod.getRoutingOnNoMockData());
    }

    private MockData getMockDataForRequest(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, InterfaceType interfaceType) {
        MockData dbMockDataFound = null;
        MockData dbMockDataMethodGlobal = null;
        boolean useCommonMockdata = this.useCommonMockdata();
        for (MockData dbMockData : this.getMockDataSorted(dbMethod.getMockData())) {
            if (!this.isMockDataRelevant(dbMockData, useCommonMockdata)) continue;
            if (Utils.isEmpty((String)dbMockData.getRequest()) && dbMockData.getPathParams().isEmpty() && dbMockData.getUrlArguments().isEmpty()) {
                dbMockDataMethodGlobal = dbMockData;
                continue;
            }
            if (!this.dataMatchesRequestContent(interfaceType, dbMockData.getRequest(), this.getPathParamsMap(dbMockData.getPathParams()), this.getUrlArgumentsMap(dbMockData.getUrlArguments()))) continue;
            dbMockDataFound = dbMockData;
            break;
        }
        if (dbMockDataFound == null) {
            dbMockDataFound = dbMockDataMethodGlobal;
        }
        return dbMockDataFound;
    }

    private Map<String, String> getPathParamsMap(List<MockDataPathParam> dbMockDataPathParams) {
        HashMap<String, String> mapPathParams = new HashMap<String, String>();
        for (MockDataPathParam dbPathParam : dbMockDataPathParams) {
            mapPathParams.put(dbPathParam.getKey(), dbPathParam.getValue());
        }
        return mapPathParams;
    }

    private Map<String, String> getUrlArgumentsMap(List<MockDataUrlArgument> dbMockDataUrlArguments) {
        HashMap<String, String> mapUrlArguments = new HashMap<String, String>();
        for (MockDataUrlArgument dbUrlArg : dbMockDataUrlArguments) {
            mapUrlArguments.put(dbUrlArg.getKey(), dbUrlArg.getValue());
        }
        return mapUrlArguments;
    }

    private boolean isMockDataRelevant(MockData dbMockData, boolean useCommonMockdata) {
        if (!Boolean.TRUE.equals(dbMockData.getActive())) {
            return false;
        }
        HttpMethod httpMethodRequest = ((CaptureCommonRequest)this.request).getHttpMethod();
        if (httpMethodRequest != null && !httpMethodRequest.toString().equals(dbMockData.getInterfaceMethod().getHttpMethod())) {
            return false;
        }
        boolean commonDbMockData = Boolean.TRUE.equals(dbMockData.getCommon()) || dbMockData.getMockProfiles().isEmpty();
        String mockProfileNameReq = ((CaptureCommonRequest)this.request).getMockProfileName();
        if (mockProfileNameReq == null) {
            if (!commonDbMockData) {
                return false;
            }
        } else if (!dbMockData.getMockProfiles().stream().anyMatch(mp -> mockProfileNameReq.equalsIgnoreCase(mp.getMockProfile().getName()))) {
            if (commonDbMockData) {
                if (!useCommonMockdata) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean useCommonMockdata() {
        if (((CaptureCommonRequest)this.request).getMockProfileName() != null) {
            MockProfile dbMockProfile = this.getDao(MockProfileDao.class).getByName(((CaptureCommonRequest)this.request).getMockProfileName(), null);
            this.leaveOn(dbMockProfile == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("mockprofile"));
            return Boolean.TRUE.equals(dbMockProfile.getUseCommonMocks());
        }
        return true;
    }

    private List<MockData> getMockDataSorted(List<MockData> mockData) {
        return mockData.stream().sorted(this.getComparatorMockData()).collect(Collectors.toList());
    }

    private Comparator<MockData> getComparatorMockData() {
        return new Comparator<MockData>(){

            @Override
            public int compare(MockData md1, MockData md2) {
                int idx2WildcardParam;
                if (!md1.getMockProfiles().isEmpty() && md2.getMockProfiles().isEmpty()) {
                    return -1;
                }
                if (md1.getMockProfiles().isEmpty() && !md2.getMockProfiles().isEmpty()) {
                    return 1;
                }
                String servicePathMethod = md1.getInterfaceMethod().getServicePath();
                String servicePathMd1 = CaptureCommon.this.getServicePathWithPathParams(servicePathMethod, md1.getPathParams());
                String servicePathMd2 = CaptureCommon.this.getServicePathWithPathParams(servicePathMethod, md2.getPathParams());
                int idx1WildcardParam = servicePathMd1.indexOf("{");
                if (idx1WildcardParam == (idx2WildcardParam = servicePathMd2.indexOf("{"))) {
                    int cntUrlArguments2;
                    int cntUrlArguments1 = Utils.nvlCollection(md1.getUrlArguments()).size();
                    if (cntUrlArguments1 == (cntUrlArguments2 = Utils.nvlCollection(md2.getUrlArguments()).size())) {
                        if (Utils.nvl((String)md1.getRequest()).length() > Utils.nvl((String)md2.getRequest()).length()) {
                            return -1;
                        }
                        return 1;
                    }
                    if (cntUrlArguments1 > cntUrlArguments2) {
                        return -1;
                    }
                    return 1;
                }
                if (idx1WildcardParam < 0 || idx1WildcardParam > idx2WildcardParam) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private String getServicePathWithPathParams(String servicePath, List<MockDataPathParam> pathParams) {
        for (MockDataPathParam pathParam : pathParams) {
            servicePath = servicePath.replace("{" + pathParam.getKey() + "}", pathParam.getValue());
        }
        return servicePath;
    }

    private boolean mockEnabled(Interface dbInterface, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, BaseData baseData) {
        if (Boolean.TRUE.equals(baseData.getMockActive())) {
            return true;
        }
        if (Boolean.FALSE.equals(baseData.getMockActive())) {
            return false;
        }
        if (Boolean.TRUE.equals(dbInterface.getMockActive())) {
            return true;
        }
        if (Boolean.FALSE.equals(dbInterface.getMockActive())) {
            return false;
        }
        return dbMethod != null && Boolean.TRUE.equals(dbMethod.getMockActive());
    }

    private void checkMockProfile() {
        this.leaveOn(((CaptureCommonRequest)this.request).getMockProfileName() != null && !this.getDao(MockProfileDao.class).existsByName(((CaptureCommonRequest)this.request).getMockProfileName(), null), ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("mockProfile " + ((CaptureCommonRequest)this.request).getMockProfileName()));
    }

    private void checkRecordSession() {
        this.leaveOn(((CaptureCommonRequest)this.request).getRecordSessionID() != null && this.entityMgr.find(de.joergdev.mosy.backend.persistence.model.RecordSession.class, ((CaptureCommonRequest)this.request).getRecordSessionID()) == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("recordSession with id " + ((CaptureCommonRequest)this.request).getRecordSessionID()));
    }

    private void doRouting(String requestContent, Interface dbInterface, BaseData baseData, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, InterfaceType interfaceType) {
        Object routingURL = dbInterface.getRoutingUrl();
        this.leaveOn(Utils.isEmpty((String)routingURL), ResponseCode.OPERATION_NOT_POSSIBLE.withAddtitionalInfo("mock not enabled and no routing configured for interface " + dbInterface.getName()));
        if (!Utils.isEmpty((String)((CaptureCommonRequest)this.request).getRouteAddition())) {
            routingURL = (String)routingURL + ((CaptureCommonRequest)this.request).getRouteAddition();
        }
        Response response = this.getRoutingResponse(requestContent, interfaceType, (String)routingURL);
        this.mockResponse = (String)response.getEntity();
        this.mockResponseHttpCode = response.getStatus();
        this.mockResponseHeaders = this.filterResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
        if (this.recordRequestResponse(baseData, dbInterface, dbMethod, interfaceType)) {
            this.saveRecord(requestContent, interfaceType, dbMethod);
        }
    }

    private Response getRoutingResponse(String requestContent, InterfaceType interfaceType, String routingURL) {
        if (InterfaceType.SOAP.equals((Object)interfaceType)) {
            return HttpRouting.doRouting(routingURL, ((CaptureCommonRequest)this.request).getAbsolutePath(), requestContent, HttpMethod.POST, this.requestHeader, true, false);
        }
        if (InterfaceType.REST.equals((Object)interfaceType)) {
            return HttpRouting.doRouting(routingURL, ((CaptureCommonRequest)this.request).getAbsolutePath(), requestContent, ((CaptureCommonRequest)this.request).getHttpMethod(), this.requestHeader, false, false);
        }
        throw new IllegalArgumentException("routing not possible for interfaceType " + String.valueOf(interfaceType));
    }

    private void saveRecord(String requestContent, InterfaceType interfaceType, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        Record apiRecord = new Record();
        apiRecord.setInterfaceMethod(new InterfaceMethod());
        apiRecord.getInterfaceMethod().setInterfaceMethodId(dbMethod.getInterfaceMethodId());
        apiRecord.getPathParams().addAll(this.getRequestPathParams(interfaceType, dbMethod));
        apiRecord.getUrlArguments().addAll(((CaptureCommonRequest)this.request).getUrlArguments());
        apiRecord.setRequestData(requestContent);
        apiRecord.setHttpReturnCode(this.mockResponseHttpCode);
        apiRecord.setResponse(this.mockResponse);
        apiRecord.setCreatedAsLdt(LocalDateTime.now());
        Integer recordSessionID = ((CaptureCommonRequest)this.request).getRecordSessionID();
        if (recordSessionID != null) {
            apiRecord.setRecordSession(new RecordSession(recordSessionID));
        }
        this.invokeSubBL(new Save(), apiRecord, new SaveResponse());
    }

    private Collection<PathParam> getRequestPathParams(InterfaceType interfaceType, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod2) {
        ArrayList<PathParam> pathParams = new ArrayList<PathParam>();
        if (InterfaceType.REST.equals((Object)interfaceType)) {
            String[] pathPartsMethod = this.dbMethod.getServicePath().split("/");
            String[] pathPartsRequest = ((CaptureCommonRequest)this.request).getServicePathMethod().split("/");
            for (int x = 0; x < pathPartsMethod.length && x < pathPartsRequest.length; ++x) {
                String pathPartMethod = pathPartsMethod[x];
                if (!pathPartMethod.startsWith("{") || !pathPartMethod.endsWith("}")) continue;
                pathParams.add(new PathParam(pathPartMethod.substring(1, pathPartMethod.length() - 1), pathPartsRequest[x]));
            }
        }
        return pathParams;
    }

    private boolean recordRequestResponse(BaseData baseData, Interface dbInterface, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, InterfaceType interfaceType) {
        RecordConfig rcMethod;
        if (dbMethod == null) {
            return false;
        }
        if (((CaptureCommonRequest)this.request).getRecordSessionID() != null) {
            return true;
        }
        if (Boolean.TRUE.equals(baseData.getRecord())) {
            return true;
        }
        if (Boolean.FALSE.equals(baseData.getRecord())) {
            return false;
        }
        RecordConfig rcInterface = dbInterface.getRecordConfig();
        if (rcInterface != null) {
            if (Boolean.TRUE.equals(rcInterface.getEnabled())) {
                return true;
            }
            if (Boolean.FALSE.equals(rcInterface.getEnabled())) {
                return false;
            }
        }
        if ((rcMethod = this.getDao(RecordConfigDAO.class).getByInterfaceMethodId(dbMethod.getInterfaceMethodId())) != null) {
            if (Boolean.TRUE.equals(rcMethod.getEnabled())) {
                return true;
            }
            if (Boolean.FALSE.equals(rcMethod.getEnabled())) {
                return false;
            }
        }
        for (RecordConfig rc : dbMethod.getRecordConfig()) {
            if (!Boolean.TRUE.equals(rc.getEnabled()) || !this.dataMatchesRequestContent(interfaceType, rc.getRequestData(), null, null)) continue;
            return true;
        }
        return false;
    }

    private boolean dataMatchesRequestContent(InterfaceType interfaceType, String needle, Map<String, String> pathParams, Map<String, String> urlArguments) {
        if (!Utils.nvlMap(pathParams).isEmpty()) {
            String servicePathMethod = this.dbMethod.getServicePath();
            for (Map.Entry<String, String> pathParam : pathParams.entrySet()) {
                servicePathMethod = servicePathMethod.replace("{" + pathParam.getKey() + "}", pathParam.getValue());
            }
            Pattern servicePathPattern = Pattern.compile(servicePathMethod = CaptureCommon.replaceInBracketsWith(servicePathMethod, ".*"));
            if (!servicePathPattern.matcher(((CaptureCommonRequest)this.request).getServicePathMethod()).matches()) {
                return false;
            }
        }
        if (!Utils.nvlMap(urlArguments).isEmpty()) {
            for (Map.Entry<String, String> urlArgEntry : urlArguments.entrySet()) {
                if (!((CaptureCommonRequest)this.request).getUrlArguments().stream().noneMatch(ua -> ua.getKey().equals(urlArgEntry.getKey()) && ua.getValue().equals(urlArgEntry.getValue()))) continue;
                return false;
            }
        }
        if (Utils.isEmpty((String)needle)) {
            return true;
        }
        return this.isXmlRequest(interfaceType) ? MockServicesUtil.xmlContainsXml(((CaptureCommonRequest)this.request).getContent(), needle) : (this.isJsonRequest(interfaceType) ? MockServicesUtil.jsonContainsJson(((CaptureCommonRequest)this.request).getContent(), needle) : MockServicesUtil.stringContainsString(((CaptureCommonRequest)this.request).getContent(), needle));
    }

    public static String replaceInBracketsWith(String input, String toReplace) {
        StringBuilder result = new StringBuilder();
        boolean inBrackets = false;
        for (char c : input.toCharArray()) {
            if (c == '{') {
                inBrackets = true;
                result.append(toReplace);
                continue;
            }
            if (c == '}' && inBrackets) {
                inBrackets = false;
                continue;
            }
            if (inBrackets) continue;
            result.append(c);
        }
        return result.toString();
    }

    private boolean isXmlRequest(InterfaceType interfaceType) {
        String reqContent;
        if (Arrays.asList(InterfaceType.SOAP, InterfaceType.CUSTOM_XML).contains(interfaceType)) {
            return true;
        }
        return !InterfaceType.CUSTOM_JSON.equals((Object)interfaceType) && (reqContent = ((CaptureCommonRequest)this.request).getContent().trim()).startsWith("<") && reqContent.endsWith(">");
    }

    private boolean isJsonRequest(InterfaceType interfaceType) {
        String reqContent;
        if (Arrays.asList(InterfaceType.CUSTOM_JSON).contains(interfaceType)) {
            return true;
        }
        return !Arrays.asList(InterfaceType.SOAP, InterfaceType.CUSTOM_XML).contains(interfaceType) && (reqContent = ((CaptureCommonRequest)this.request).getContent().trim()).startsWith("{") && reqContent.endsWith("}");
    }

    @Override
    protected void fillOutput() {
        ((CaptureCommonResponse)this.response).setResponse(this.mockResponse);
        ((CaptureCommonResponse)this.response).setResponseHttpCode(this.mockResponseHttpCode);
        ((CaptureCommonResponse)this.response).setResponseHeaders(this.mockResponseHeaders);
        if (this.dbMethod != null) {
            InterfaceMethod apiMethod = new InterfaceMethod();
            apiMethod.setInterfaceMethodId(this.dbMethod.getInterfaceMethodId());
            apiMethod.setName(this.dbMethod.getName());
            de.joergdev.mosy.api.model.Interface apiInterface = new de.joergdev.mosy.api.model.Interface();
            apiInterface.setInterfaceId(this.dbMethod.getMockInterface().getInterfaceId());
            apiInterface.setName(this.dbMethod.getMockInterface().getName());
            apiMethod.setMockInterfaceData(apiInterface);
            ((CaptureCommonResponse)this.response).setInterfaceMethod(apiMethod);
        }
    }

    private MultivaluedMap<String, Object> filterResponseHeaders(MultivaluedMap<String, Object> mockResponseHeadersTmp) {
        Iterator it = mockResponseHeadersTmp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (!"Transfer-encoding".equals(e.getKey()) || !((List)e.getValue()).remove("chunked") || !((List)e.getValue()).isEmpty()) continue;
            it.remove();
        }
        return mockResponseHeadersTmp;
    }
}

