/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockdata;

import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.InterfaceType;
import de.joergdev.mosy.api.model.MockData;
import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.mockdata.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.utils.BlUtils;
import de.joergdev.mosy.backend.bl.utils.PersistenceUtil;
import de.joergdev.mosy.backend.persistence.dao.MockDataDAO;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.model.MockDataMockProfile;
import de.joergdev.mosy.backend.persistence.model.MockDataPathParam;
import de.joergdev.mosy.backend.persistence.model.MockDataUrlArgument;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXParseException;

public class Save
extends AbstractBL<MockData, SaveResponse> {
    private InterfaceMethod apiInterfaceMethodRequest = null;
    private Interface apiInterfaceRequest = null;
    private de.joergdev.mosy.backend.persistence.model.MockData dbMockData;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(Utils.isEmpty((String)((MockData)this.request).getTitle()) || ((MockData)this.request).getTitle().length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("title"));
        this.apiInterfaceMethodRequest = ((MockData)this.request).getInterfaceMethod();
        this.leaveOn(this.apiInterfaceMethodRequest == null || this.apiInterfaceMethodRequest.getInterfaceMethodId() == null && Utils.isEmpty((String)this.apiInterfaceMethodRequest.getName()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method"));
        this.apiInterfaceRequest = this.apiInterfaceMethodRequest.getMockInterface();
        this.leaveOn(this.apiInterfaceMethodRequest.getInterfaceMethodId() == null && (this.apiInterfaceRequest == null || this.apiInterfaceRequest.getInterfaceId() == null && Utils.isEmpty((String)this.apiInterfaceRequest.getName())), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface"));
        this.leaveOn(!Utils.isEmpty((String)((MockData)this.request).getRequest()) && ((MockData)this.request).getRequest().length() > 500000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(!Utils.isEmpty((String)((MockData)this.request).getResponse()) && ((MockData)this.request).getResponse().length() > 500000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("response"));
        for (de.joergdev.mosy.api.model.MockProfile apiMockProfile : ((MockData)this.request).getMockProfiles()) {
            Integer apiMockProfileID = apiMockProfile.getMockProfileID();
            this.leaveOn(apiMockProfileID != null && !Utils.isPositive((Number)apiMockProfileID), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockProfileID"));
            this.leaveOn(apiMockProfileID == null && Utils.isEmpty((String)apiMockProfile.getName()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockProfileID / name"));
        }
        for (PathParam pathParam : ((MockData)this.request).getPathParams()) {
            this.leaveOn(Utils.isEmpty((String)pathParam.getKey()) || Utils.isEmpty((String)pathParam.getValue()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("pathParam"));
            this.leaveOn(pathParam.getKey().length() > 100, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("pathParam key"));
            this.leaveOn(pathParam.getValue().length() > 100, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("pathParam value"));
        }
        for (UrlArgument urlArg : ((MockData)this.request).getUrlArguments()) {
            this.leaveOn(Utils.isEmpty((String)urlArg.getKey()) || Utils.isEmpty((String)urlArg.getValue()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("urlArgument"));
            this.leaveOn(urlArg.getKey().length() > 100, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("urlArgument"));
            this.leaveOn(urlArg.getValue().length() > 100, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("urlArgument"));
        }
    }

    @Override
    protected void execute() {
        this.loadOrCreateDbMockData();
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = this.getDbMethod();
        this.leaveOn(this.dbMockData.getInterfaceMethod() != null && !dbMethod.getInterfaceMethodId().equals(this.dbMockData.getInterfaceMethod().getInterfaceMethodId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockdata and interfaceMethod wrong"));
        this.leaveOn(!InterfaceType.REST.id.equals(BlUtils.getInterfaceTypeId(this.apiInterfaceMethodRequest, dbMethod)) && Utils.isEmpty((String)((MockData)this.request).getResponse()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("response"));
        Map<Integer, MockProfile> dbMockProfiles = this.getMockProfilesFromRequest();
        this.setCommonIfNoMockProfile();
        this.checkUniqueData();
        this.formatRequestResponse(dbMethod);
        ((MockData)this.request).setRequestResponseHash();
        ObjectUtils.copyValues((Object)this.request, (Object)this.dbMockData, (String[])new String[]{"interfaceMethod", "mockProfile", "created", "countCalls", "mockProfiles", "pathParams", "urlArguments"});
        this.dbMockData.setInterfaceMethod(dbMethod);
        this.entityMgr.persist(this.dbMockData);
        this.entityMgr.flush();
        this.saveMockProfiles(dbMockProfiles);
        this.savePathParams();
        this.saveUrlArguments();
    }

    private void setCommonIfNoMockProfile() {
        if (((MockData)this.request).getMockProfiles().isEmpty() && !Boolean.TRUE.equals(((MockData)this.request).getCommon())) {
            ((MockData)this.request).setCommon(true);
            this.addResponseMessage(ResponseCode.DATA_SET.withAddtitionalInfo("mockdata set to common"));
        }
    }

    private void formatRequestResponse(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        try {
            ((MockData)this.request).formatRequestResponse(BlUtils.getInterfaceTypeId(this.apiInterfaceMethodRequest, dbMethod));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof SAXParseException) {
                this.leave(ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request / response xml format"));
            }
            throw ex;
        }
    }

    private void saveMockProfiles(Map<Integer, MockProfile> dbMockProfiles) {
        boolean dbChanged = false;
        for (MockDataMockProfile dbMockDataMockProfile : Utils.nvlCollection(this.dbMockData.getMockProfiles())) {
            Integer dbMockProfileID = dbMockDataMockProfile.getMockProfile().getMockProfileID();
            if (dbMockProfiles.containsKey(dbMockProfileID)) {
                dbMockProfiles.remove(dbMockProfileID);
                continue;
            }
            this.entityMgr.remove(this.entityMgr.find(MockDataMockProfile.class, dbMockDataMockProfile.getMockDataMockProfileId()));
            dbChanged = true;
        }
        for (Integer mockProfileID : dbMockProfiles.keySet()) {
            MockDataMockProfile dbMockDataMockProfile = new MockDataMockProfile();
            dbMockDataMockProfile.setMockData(this.dbMockData);
            dbMockDataMockProfile.setMockProfile(dbMockProfiles.get(mockProfileID));
            this.entityMgr.persist(dbMockDataMockProfile);
            dbChanged = true;
        }
        if (dbChanged) {
            this.entityMgr.flush();
        }
    }

    private void savePathParams() {
        boolean dbChanged = false;
        for (MockDataPathParam dbPathParam : Utils.nvlCollection(this.dbMockData.getPathParams())) {
            this.entityMgr.remove(this.entityMgr.find(MockDataPathParam.class, dbPathParam.getMockDataPathParamId()));
            dbChanged = true;
        }
        for (PathParam pathParam : ((MockData)this.request).getPathParams()) {
            MockDataPathParam dbPathParam = new MockDataPathParam();
            dbPathParam.setKey(pathParam.getKey());
            dbPathParam.setValue(pathParam.getValue());
            dbPathParam.setMockData(this.dbMockData);
            this.entityMgr.persist(dbPathParam);
            dbChanged = true;
        }
        if (dbChanged) {
            this.entityMgr.flush();
        }
    }

    private void saveUrlArguments() {
        boolean dbChanged = false;
        for (MockDataUrlArgument dbUrlArg : Utils.nvlCollection(this.dbMockData.getUrlArguments())) {
            this.entityMgr.remove(this.entityMgr.find(MockDataUrlArgument.class, dbUrlArg.getMockDataUrlArgumentId()));
            dbChanged = true;
        }
        for (UrlArgument urlArg : ((MockData)this.request).getUrlArguments()) {
            MockDataUrlArgument dbUrlArg = new MockDataUrlArgument();
            dbUrlArg.setKey(urlArg.getKey());
            dbUrlArg.setValue(urlArg.getValue());
            dbUrlArg.setMockData(this.dbMockData);
            this.entityMgr.persist(dbUrlArg);
            dbChanged = true;
        }
        if (dbChanged) {
            this.entityMgr.flush();
        }
    }

    private Map<Integer, MockProfile> getMockProfilesFromRequest() {
        HashMap<Integer, MockProfile> dbMockProfiles = new HashMap<Integer, MockProfile>();
        for (de.joergdev.mosy.api.model.MockProfile apiMockProfile : ((MockData)this.request).getMockProfiles()) {
            Integer mockProfileID = apiMockProfile.getMockProfileID();
            MockProfile dbMockProfile = null;
            if (mockProfileID != null) {
                dbMockProfile = this.findDbEntity(MockProfile.class, mockProfileID, "mockProfile with id: " + mockProfileID);
            } else {
                dbMockProfile = this.getDao(MockProfileDao.class).getByName(apiMockProfile.getName(), null);
                this.leaveOn(dbMockProfile == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("mockProfile " + apiMockProfile.getName()));
                mockProfileID = dbMockProfile.getMockProfileID();
            }
            dbMockProfiles.put(mockProfileID, dbMockProfile);
        }
        return dbMockProfiles;
    }

    private de.joergdev.mosy.backend.persistence.model.InterfaceMethod getDbMethod() {
        Integer interfaceMethodID = this.apiInterfaceMethodRequest.getInterfaceMethodId();
        if (interfaceMethodID != null) {
            return this.findDbEntity(de.joergdev.mosy.backend.persistence.model.InterfaceMethod.class, interfaceMethodID, "interface method with id " + interfaceMethodID);
        }
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbInterfaceMethod = PersistenceUtil.getDbInterfaceMethodByNames(this, this.apiInterfaceRequest.getName(), this.apiInterfaceMethodRequest.getName(), false, this.apiInterfaceMethodRequest.getHttpMethod());
        this.apiInterfaceMethodRequest.setInterfaceMethodId(dbInterfaceMethod.getInterfaceMethodId());
        this.apiInterfaceRequest.setInterfaceId(dbInterfaceMethod.getMockInterface().getInterfaceId());
        return dbInterfaceMethod;
    }

    private void loadOrCreateDbMockData() {
        if (((MockData)this.request).getMockDataId() != null) {
            this.dbMockData = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.MockData.class, ((MockData)this.request).getMockDataId(), "mockData with id " + ((MockData)this.request).getMockDataId());
        } else {
            this.dbMockData = new de.joergdev.mosy.backend.persistence.model.MockData();
            this.dbMockData.setCreated(LocalDateTime.now());
            this.dbMockData.setCountCalls(0);
        }
    }

    private void checkUniqueData() {
        this.leaveOn(this.getDao(MockDataDAO.class).existsByTitle(((MockData)this.request).getInterfaceMethod().getInterfaceMethodId(), ((MockData)this.request).getTitle(), ((MockData)this.request).getMockDataId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("mockData with title: " + ((MockData)this.request).getTitle()));
    }

    @Override
    protected void fillOutput() {
        MockData apiMockDateResponse = new MockData();
        apiMockDateResponse.setMockDataId(this.dbMockData.getMockDataId());
        apiMockDateResponse.setCreatedAsLdt(this.dbMockData.getCreated());
        apiMockDateResponse.setCountCalls(this.dbMockData.getCountCalls());
        apiMockDateResponse.setActive(this.dbMockData.getActive().booleanValue());
        apiMockDateResponse.setCommon(this.dbMockData.getCommon().booleanValue());
        ((SaveResponse)this.response).setMockData(apiMockDateResponse);
    }
}

