/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.core;

import de.joergdev.mosy.api.response.AbstractResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.ResponseMessage;
import de.joergdev.mosy.backend.bl.core.BLEntityManager;
import de.joergdev.mosy.backend.bl.core.BLException;
import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.security.TokenManagerService;
import jakarta.persistence.EntityManager;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBL<T, K extends AbstractResponse> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected T request;
    protected K response;
    private String token;
    protected boolean checkToken = true;
    protected boolean isSubcall = false;
    protected BLEntityManager entityMgr;

    public void executeCore(boolean throwException) {
        block2: {
            try {
                this.beforeExecute();
                Objects.requireNonNull(this.response, "response");
                this.checkSecurity();
                this.validateInput();
                this.execute();
                this.fillOutput();
                this.response.setStateOK(true);
            }
            catch (BLException ble) {
                if (!throwException) break block2;
                throw ble;
            }
        }
    }

    protected void beforeExecute() {
    }

    private void checkSecurity() {
        this.leaveOn(this.checkToken && !TokenManagerService.validateToken(this.token), ResponseCode.ACCESS_DENIED);
    }

    public void leave(ResponseCode rspCode) {
        this.leave(new ResponseMessage(rspCode));
    }

    public void leave(ResponseCode rspCode, Throwable t) {
        this.leave(rspCode, t);
    }

    public void leaveOn(boolean expression, ResponseCode rspCode) {
        this.leaveOn(expression, new ResponseMessage(rspCode));
    }

    public void leave(ResponseMessage respM) throws BLException {
        this.addResponseMessage(respM);
        throw new BLException(respM);
    }

    public void leave(ResponseMessage rspM, Throwable t) {
        this.log.error(rspM.getFullMessage(), t);
        this.leave(rspM);
    }

    public void leaveOn(boolean expression, Supplier<ResponseMessage> rspM) {
        if (expression) {
            this.leave(rspM.get());
        }
    }

    public void leaveOn(boolean expression, ResponseMessage rspM) {
        if (expression) {
            this.leave(rspM);
        }
    }

    public void addResponseCode(ResponseCode rspCode) {
        this.addResponseMessage(new ResponseMessage(rspCode));
    }

    public void addResponseMessage(ResponseMessage rspM) {
        this.response.getMessages().add(Objects.requireNonNull(rspM, "rspM"));
    }

    protected abstract void validateInput();

    protected abstract void execute();

    protected abstract void fillOutput();

    public <L, M extends AbstractResponse> M invokeSubBL(AbstractBL<L, M> bl, L request, M response) {
        return this.invokeSubBL(bl, request, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L, M extends AbstractResponse> M invokeSubBL(AbstractBL<L, M> bl, L request, M response, boolean throwException) {
        bl.isSubcall = true;
        bl.setToken(this.token);
        bl.checkToken = false;
        bl.setRequest(request);
        bl.setResponse(response);
        bl.setEntityMgr(this.entityMgr);
        try {
            bl.executeCore(throwException);
        }
        finally {
            response.getMessages().addAll(bl.getResponse().getMessages());
        }
        return response;
    }

    public AbstractResponse getResponse() {
        return this.response;
    }

    public void setResponse(K response) {
        this.response = response;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public EntityManager getEntityMgr() {
        return this.entityMgr;
    }

    public void setEntityMgr(EntityManager entityMgr) {
        this.entityMgr = entityMgr != null ? new BLEntityManager(entityMgr, this.getTenantId()) : null;
    }

    public <L extends AbstractDAO> L getDao(Class<L> daoClass) {
        try {
            AbstractDAO dao = (AbstractDAO)daoClass.newInstance();
            dao.setEntityMgr(this.entityMgr);
            dao.setTenantId(this.getTenantId());
            return (L)dao;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public <L> L findDbEntity(Class<L> entityClass, Object pk, String errorOnNull) {
        L entity = this.entityMgr.find(entityClass, pk);
        this.leaveOn(entity == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo(errorOnNull));
        return entity;
    }

    protected Integer getTenantId() {
        return TokenManagerService.getTenantId(this.token);
    }
}

