/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl._interface;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.InterfaceType;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response._interface.LoadResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.InterfaceMethodDAO;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;

public class Load
extends AbstractBL<Integer, LoadResponse> {
    private final Interface apiInterface = new Interface();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null || !Utils.isPositive((Number)((Number)this.request)), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("name"));
    }

    @Override
    protected void execute() {
        de.joergdev.mosy.backend.persistence.model.Interface dbInterface = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.Interface.class, this.request, "no interface with id: " + String.valueOf(this.request));
        ObjectUtils.copyValues((Object)dbInterface, (Object)this.apiInterface, (String[])new String[]{"type", "methods"});
        if (dbInterface.getType() != null) {
            this.apiInterface.setType(InterfaceType.getById((Integer)dbInterface.getType().getInterfaceTypeId()));
        } else {
            this.apiInterface.setType(null);
        }
        this.transferMethods(dbInterface);
        this.apiInterface.setRecord(dbInterface.getRecordConfig() == null ? null : Boolean.valueOf(Boolean.TRUE.equals(dbInterface.getRecordConfig().getEnabled())));
    }

    private void transferMethods(de.joergdev.mosy.backend.persistence.model.Interface dbInterface) {
        for (de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod : dbInterface.getMethods()) {
            InterfaceMethod apiMethod = new InterfaceMethod();
            apiMethod.setMockInterfaceData(this.apiInterface);
            this.apiInterface.getMethods().add(apiMethod);
            ObjectUtils.copyValues((Object)dbMethod, (Object)apiMethod, (String[])new String[]{"mockInterface", "httpMethod"});
            String httpMethod = dbMethod.getHttpMethod();
            if (!Utils.isEmpty((String)httpMethod)) {
                apiMethod.setHttpMethod(HttpMethod.valueOf((String)httpMethod));
            }
            apiMethod.setRecord(this.getDao(InterfaceMethodDAO.class).isRecordEnabled(dbMethod.getInterfaceMethodId()));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadResponse)this.response).setInterface(this.apiInterface);
    }
}

