/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.api.impl;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.request.tenant.SaveRequest;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.tenant.LoadAllResponse;
import de.joergdev.mosy.api.response.tenant.SaveResponse;
import de.joergdev.mosy.backend.api.APIUtils;
import de.joergdev.mosy.backend.bl.tenant.Delete;
import de.joergdev.mosy.backend.bl.tenant.LoadAll;
import de.joergdev.mosy.backend.bl.tenant.Save;
import de.joergdev.mosy.backend.util.HttpRouting;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;

@Path(value="mosy/api/v_5_0/tenants")
public class Tenants {
    @GET
    public Response loadAll() {
        return APIUtils.executeBL(null, new LoadAllResponse(), new LoadAll());
    }

    @Path(value="save")
    @POST
    public Response save(@HeaderParam(value="Authorization") String token, SaveRequest request) {
        return APIUtils.executeBL(request, new SaveResponse(), new Save(), token);
    }

    @Path(value="{id}/delete")
    @DELETE
    public Response delete(@HeaderParam(value="Authorization") String token, @PathParam(value="id") Integer id) {
        return APIUtils.executeBL(id, new EmptyResponse(), new Delete(), token);
    }

    @Path(value="{id}/{pth:.+}")
    @POST
    public Response routePostRequest(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="id") Integer id, String content) {
        return this.routeRequest(headers, uriInfo, id, content, HttpMethod.POST);
    }

    @Path(value="{id}/{pth:.+}")
    @PUT
    public Response routePutRequest(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="id") Integer id, String content) {
        return this.routeRequest(headers, uriInfo, id, content, HttpMethod.PUT);
    }

    @Path(value="{id}/{pth:.+}")
    @DELETE
    public Response routeDeleteRequest(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="id") Integer id, String content) {
        return this.routeRequest(headers, uriInfo, id, content, HttpMethod.DELETE);
    }

    @Path(value="{id}/{pth:.+}")
    @GET
    public Response routeGetRequest(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="id") Integer id, String content) {
        return this.routeRequest(headers, uriInfo, id, content, HttpMethod.GET);
    }

    private Response routeRequest(HttpHeaders headers, UriInfo uriInfo, Integer id, String content, HttpMethod httpMethod) {
        String endpointCalled = uriInfo.getAbsolutePath().toString() + UrlArgument.getUrlPartForUrlArguments((Map)uriInfo.getQueryParameters());
        String routingURL = this.getRoutingUrl(endpointCalled, id);
        MultivaluedMap headersMap = headers.getRequestHeaders();
        headersMap.add((Object)"HTTP_HEADER_TENANT_ID", (Object)String.valueOf(id));
        boolean isSOAP = endpointCalled.contains("/mock-services/soap/");
        Response responseRouted = HttpRouting.doRouting(routingURL, endpointCalled, content, httpMethod, (MultivaluedMap<String, String>)headersMap, isSOAP, true);
        Response.ResponseBuilder responseBui = Response.status((int)responseRouted.getStatus());
        responseBui.entity(responseRouted.getEntity());
        responseBui.allow(responseRouted.getAllowedMethods());
        responseBui.location(responseRouted.getLocation());
        responseBui.type(responseRouted.getMediaType());
        return responseBui.build();
    }

    private String getRoutingUrl(String endpointCalled, Integer id) {
        String routingURL = endpointCalled.replace("/tenants/" + id, "");
        if (routingURL.endsWith("/")) {
            routingURL = routingURL.substring(0, routingURL.length() - 1);
        }
        if (routingURL.endsWith("mosy/api/v_5_0/tenants")) {
            throw new IllegalArgumentException("invalid url called");
        }
        return routingURL;
    }
}

