/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.api.impl;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.request.mockservices.CustomRequestRequest;
import de.joergdev.mosy.api.response.ResponseMessage;
import de.joergdev.mosy.api.response.mockservices.CustomRequestResponse;
import de.joergdev.mosy.backend.api.APIUtils;
import de.joergdev.mosy.backend.api.intern.request.mockservices.CaptureCommonRequest;
import de.joergdev.mosy.backend.api.intern.request.mockservices.CaptureSoapRequest;
import de.joergdev.mosy.backend.api.intern.response.mockservices.CaptureCommonResponse;
import de.joergdev.mosy.backend.bl.mockservices.CaptureCommon;
import de.joergdev.mosy.backend.bl.mockservices.CaptureRest;
import de.joergdev.mosy.backend.bl.mockservices.CaptureSoap;
import de.joergdev.mosy.shared.Utils;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@Path(value="mosy/api/v_5_0/mock-services")
public class MockServices {
    @Path(value="soap/{pth:.+}")
    @POST
    @Produces(value={"text/xml"})
    public Response captureSoap(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, String content) {
        CaptureSoapRequest blRequest = new CaptureSoapRequest();
        blRequest.setPath(path);
        blRequest.setContent(content);
        blRequest.setHttpHeaders(headers);
        blRequest.setAbsolutePath(uriInfo.getAbsolutePath().toString());
        CaptureCommonResponse blResponse = new CaptureCommonResponse();
        APIUtils.executeBL(blRequest, blResponse, new CaptureSoap());
        return this.getResponseByCaptureResponse(blResponse, null, true);
    }

    @Path(value="soap/{pth:.+}")
    @GET
    @Produces(value={"text/html"})
    public Response captureSoapWsdlRequest(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MultivaluedMap qryParams = uriInfo.getQueryParameters();
        if (qryParams.keySet().stream().anyMatch(p -> "wsdl".equalsIgnoreCase((String)p))) {
            CaptureSoapRequest blRequest = new CaptureSoapRequest();
            blRequest.setPath(path);
            blRequest.setHttpHeaders(headers);
            blRequest.setWsdlRequest(true);
            blRequest.setAbsolutePath(uriInfo.getAbsolutePath().toString());
            CaptureCommonResponse blResponse = new CaptureCommonResponse();
            APIUtils.executeBL(blRequest, blResponse, new CaptureSoap());
            return this.getResponseByCaptureResponse(blResponse, null, false);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="rest/{pth:.+}")
    @POST
    public Response captureRestPost(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, String content) {
        return this.captureRest(path, HttpMethod.POST, headers, uriInfo, content);
    }

    @Path(value="rest/{pth:.+}")
    @PUT
    public Response captureRestPut(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, String content) {
        return this.captureRest(path, HttpMethod.PUT, headers, uriInfo, content);
    }

    @Path(value="rest/{pth:.+}")
    @DELETE
    public Response captureRestDelete(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, String content) {
        return this.captureRest(path, HttpMethod.DELETE, headers, uriInfo, content);
    }

    @Path(value="rest/{pth:.+}")
    @GET
    public Response captureRestGet(@PathParam(value="pth") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, String content) {
        return this.captureRest(path, HttpMethod.GET, headers, uriInfo, content);
    }

    private Response captureRest(String path, HttpMethod httpMethod, HttpHeaders headers, UriInfo uriInfo, String content) {
        CaptureCommonRequest commonReq = new CaptureCommonRequest();
        commonReq.setHttpHeaders(headers);
        commonReq.setContent(content);
        commonReq.setServicePathInterface(path);
        commonReq.setHttpMethod(httpMethod);
        commonReq.getUrlArguments().addAll(UrlArgument.getUrlArgumentsFromMap((Map)uriInfo.getQueryParameters()));
        CaptureCommonResponse commonResp = new CaptureCommonResponse();
        APIUtils.executeBL(commonReq, commonResp, new CaptureRest());
        return this.getResponseByCaptureResponse(commonResp, () -> commonResp.getResponseHttpCode(), false);
    }

    @Path(value="custom-request")
    @POST
    public Response customRequest(@Context HttpHeaders headers, CustomRequestRequest request) {
        CaptureCommonRequest commonReq = new CaptureCommonRequest();
        commonReq.setServicePathInterface(request.getInterfaceName());
        commonReq.setServicePathMethod(request.getInterfaceMethod());
        commonReq.setContent(request.getRequest());
        commonReq.setHttpHeaders(headers);
        CaptureCommonResponse commonResp = new CaptureCommonResponse();
        APIUtils.executeBL(commonReq, commonResp, new CaptureCommon());
        CustomRequestResponse customResponse = new CustomRequestResponse();
        customResponse.setResponse(commonResp.getResponse());
        customResponse.setRecord(Boolean.TRUE.equals(commonResp.getRecord()));
        customResponse.setRoute(Boolean.TRUE.equals(commonResp.getRoute()));
        customResponse.setInterfaceMethod(commonResp.getInterfaceMethod());
        customResponse.setStateOK(commonResp.isStateOK());
        customResponse.getMessages().addAll(commonResp.getMessages());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)customResponse).build();
    }

    private Response getResponseByCaptureResponse(CaptureCommonResponse blResponse, Supplier<Integer> getterHttpReturnCode, boolean soap) {
        Response.ResponseBuilder responseBui = null;
        if (blResponse.isStateOK()) {
            Integer httpReturnCode = getterHttpReturnCode == null ? null : getterHttpReturnCode.get();
            responseBui = Response.status((Response.Status)(httpReturnCode == null ? Response.Status.OK : Response.Status.fromStatusCode((int)getterHttpReturnCode.get())));
            String entity = blResponse.getResponse();
            if (entity != null) {
                responseBui = responseBui.entity((Object)entity);
            }
        } else {
            StringBuilder buiMsg = new StringBuilder();
            Iterator itMsg = blResponse.getMessages().iterator();
            while (itMsg.hasNext()) {
                buiMsg.append(((ResponseMessage)itMsg.next()).toString());
                if (!itMsg.hasNext()) continue;
                buiMsg.append("\n\n");
            }
            String errorMsg = buiMsg.toString();
            responseBui = soap ? this.getResponseForFailedSoapRequest(errorMsg) : Response.serverError().entity((Object)errorMsg);
        }
        MultivaluedMap<String, Object> headers = blResponse.getResponseHeaders();
        if (headers != null) {
            for (Map.Entry headerEntry : headers.entrySet()) {
                String headerKey = (String)headerEntry.getKey();
                List headerList = (List)headerEntry.getValue();
                if (Utils.isEmpty((String)headerKey) || headerList == null || this.isHeaderKeyBlacklisted(headerKey)) continue;
                for (Object headerVal : headerList) {
                    if (headerVal == null) continue;
                    responseBui.header(headerKey, headerVal);
                }
            }
        }
        return responseBui.build();
    }

    private boolean isHeaderKeyBlacklisted(String headerKey) {
        return Arrays.asList("Transfer-Encoding").contains(headerKey);
    }

    private Response.ResponseBuilder getResponseForFailedSoapRequest(String errorMsg) {
        errorMsg = errorMsg.replace("<", "#o").replace(">", "#e");
        StringBuilder buiSoap = new StringBuilder();
        buiSoap.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        buiSoap.append("  <soap:Body>");
        buiSoap.append("    <soap:Fault>");
        buiSoap.append("      <faultcode>soap:Server</faultcode>");
        buiSoap.append("      <faultstring>").append(errorMsg).append("</faultstring>");
        buiSoap.append("    </soap:Fault>");
        buiSoap.append("  </soap:Body>");
        buiSoap.append("</soap:Envelope>");
        return Response.ok().entity((Object)buiSoap.toString());
    }
}

