/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.api;

import de.joergdev.mosy.api.response.AbstractResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.ResponseMessage;
import de.joergdev.mosy.api.response.ResponseMessageLevel;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.core.BLException;
import de.joergdev.mosy.backend.persistence.EntityManagerProviderService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class APIUtils {
    private static final Logger LOG = LogManager.getLogger(APIUtils.class);

    public static <T extends AbstractResponse, R> Response executeBL(R request, T response, AbstractBL<R, T> bl) {
        return APIUtils.executeBL(request, response, bl, null, Response.Status.OK);
    }

    public static <T extends AbstractResponse, R> Response executeBL(R request, T response, AbstractBL<R, T> bl, Response.Status statusOnSuccess) {
        return APIUtils.executeBL(request, response, bl, null, statusOnSuccess);
    }

    public static <T extends AbstractResponse, R> Response executeBL(R request, T response, AbstractBL<R, T> bl, String token) {
        return APIUtils.executeBL(request, response, bl, token, Response.Status.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractResponse, R> Response executeBL(R blRequest, T blResponse, AbstractBL<R, T> bl, String token, Response.Status statusOnSuccess) {
        Response.ResponseBuilder responseBui = null;
        EntityManager em = null;
        EntityTransaction tx = null;
        try {
            em = EntityManagerProviderService.getInstance().getEntityManager();
            if (!EntityManagerProviderService.getInstance().isContainerManaged()) {
                tx = em.getTransaction();
                tx.begin();
            }
            bl.setToken(token);
            bl.setRequest(blRequest);
            bl.setResponse(blResponse);
            bl.setEntityMgr(em);
            bl.executeCore(true);
            if (!EntityManagerProviderService.getInstance().isContainerManaged()) {
                tx.commit();
            }
            responseBui = Response.status((Response.Status)statusOnSuccess);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            if (bl.getResponse() != null && !bl.getResponse().getMessages().stream().anyMatch(msg -> ResponseMessageLevel.ERROR.equals((Object)msg.getResponseCode().level))) {
                bl.addResponseMessage(ResponseCode.UNEXPECTED_ERROR.withAddtitionalInfo(ex.getMessage()));
            }
            EntityManagerProviderService.getInstance().rollbackEntityManager(em);
            blResponse.setStateOK(false);
            responseBui = APIUtils.createResponseBuilderOnError(ex);
        }
        finally {
            if (em != null) {
                EntityManagerProviderService.getInstance().releaseEntityManager(em);
            }
        }
        return responseBui.entity(blResponse).build();
    }

    private static Response.ResponseBuilder createResponseBuilderOnError(Exception ex) {
        ResponseMessage rspm;
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (ex instanceof BLException && (rspm = ((BLException)ex).getResponseMessage()) != null && !ResponseCode.UNEXPECTED_ERROR.equals((Object)rspm.getResponseCode())) {
            status = Response.Status.OK;
        }
        return Response.status((Response.Status)status);
    }
}

