/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.security;

import de.joergdev.mosy.backend.Config;
import de.joergdev.mosy.backend.security.Token;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;

public class TokenManagerService {
    private static final TokenHolder TOKEN_HOLDER = new TokenHolder();

    public static String createToken(int hash, Integer tenantId, Integer hashForTenant, IntSupplier defaultTenantIdForNonMultiTanencySupplier) {
        if (!TokenManagerService.checkSecret(hash, hashForTenant)) {
            return null;
        }
        return TokenManagerService.createToken(tenantId, defaultTenantIdForNonMultiTanencySupplier);
    }

    public static String createTokenWithoutSecretCheck(Integer tenantId, IntSupplier defaultTenantIdForNonMultiTanencySupplier) {
        return TokenManagerService.createToken(tenantId, defaultTenantIdForNonMultiTanencySupplier);
    }

    private static String createToken(Integer tenantId, IntSupplier defaultTenantIdForNonMultiTanencySupplier) {
        Token token = Token.of("@MOSY_" + (double)System.currentTimeMillis() / Math.random(), TokenManagerService.getTenantIdForToken(tenantId, defaultTenantIdForNonMultiTanencySupplier));
        TokenManagerService.TOKEN_HOLDER.tokens.put(token, token);
        return token.getTokenId();
    }

    private static Integer getTenantIdForToken(Integer tenantId, IntSupplier defaultTenantIdForNonMultiTanencySupplier) {
        return Config.isMultiTenancyEnabled() ? tenantId.intValue() : defaultTenantIdForNonMultiTanencySupplier.getAsInt();
    }

    private static boolean checkSecret(int hash, Integer hashForTenant) {
        if (Config.isMultiTenancyEnabled()) {
            return hashForTenant != null && hash == hashForTenant;
        }
        return hash == Config.getLoginSecret();
    }

    public static boolean validateToken(String token) {
        return TokenManagerService.TOKEN_HOLDER.tokens.keySet().contains(Token.of(token));
    }

    public static boolean invalidateToken(String token) {
        return TokenManagerService.TOKEN_HOLDER.tokens.remove(Token.of(token)) != null;
    }

    public static Integer getTenantId(String token) {
        Token tokenObj = TokenManagerService.TOKEN_HOLDER.tokens.get(Token.of(token));
        return tokenObj == null ? null : tokenObj.getTenantId();
    }

    private static class TokenHolder {
        private final Map<Token, Token> tokens = new HashMap<Token, Token>();

        private TokenHolder() {
        }
    }
}

