/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.model;

import de.joergdev.mosy.backend.persistence.model.InterfaceMethod;
import de.joergdev.mosy.backend.persistence.model.RecordPathParam;
import de.joergdev.mosy.backend.persistence.model.RecordSession;
import de.joergdev.mosy.backend.persistence.model.RecordUrlArgument;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.persistence.model.TenantScoped;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity
@Table(name="RECORD")
public class Record
implements TenantScoped {
    @Column(name="RECORD_ID")
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer recordId;
    @ManyToOne
    @JoinColumn(name="INTERFACE_METHOD_ID")
    @OnDelete(action=OnDeleteAction.CASCADE)
    private InterfaceMethod interfaceMethod;
    @ManyToOne
    @JoinColumn(name="TENANT_ID", nullable=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Tenant tenant;
    @Column(name="REQUEST_DATA", length=500000)
    private String requestData;
    @Column(name="HTTP_RETURN_CODE", nullable=true, length=4)
    private Integer httpReturnCode;
    @Column(name="RESPONSE", length=500000)
    private String response;
    @Column(name="CREATED", updatable=false)
    private LocalDateTime created;
    @ManyToOne
    @JoinColumn(name="RECORD_SESSION_ID")
    @OnDelete(action=OnDeleteAction.CASCADE)
    private RecordSession recordSession;
    @OneToMany(mappedBy="record", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<RecordPathParam> pathParams;
    @OneToMany(mappedBy="record", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<RecordUrlArgument> urlArguments;

    public Integer getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Integer recordId) {
        this.recordId = recordId;
    }

    public InterfaceMethod getInterfaceMethod() {
        return this.interfaceMethod;
    }

    public void setInterfaceMethod(InterfaceMethod interfaceMethod) {
        this.interfaceMethod = interfaceMethod;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public RecordSession getRecordSession() {
        return this.recordSession;
    }

    public void setRecordSession(RecordSession recordSession) {
        this.recordSession = recordSession;
    }

    public Integer getHttpReturnCode() {
        return this.httpReturnCode;
    }

    public void setHttpReturnCode(Integer httpReturnCode) {
        this.httpReturnCode = httpReturnCode;
    }

    public List<RecordPathParam> getPathParams() {
        return this.pathParams;
    }

    public void setPathParams(List<RecordPathParam> pathParams) {
        this.pathParams = pathParams;
    }

    public List<RecordUrlArgument> getUrlArguments() {
        return this.urlArguments;
    }

    public void setUrlArguments(List<RecordUrlArgument> urlArguments) {
        this.urlArguments = urlArguments;
    }

    @Override
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }
}

