/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao.core;

import de.joergdev.mosy.backend.bl.utils.TenancyUtils;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.shared.Utils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;

public class AbstractDAO {
    protected EntityManager entityMgr;
    protected Integer tenantId;

    public EntityManager getEntityMgr() {
        return this.entityMgr;
    }

    public void setEntityMgr(EntityManager entityMgr) {
        this.entityMgr = entityMgr;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public <T> T getSingleResult(Query q) {
        List<T> result = this.getResultList(q);
        return Utils.isCollectionEmpty(result) ? null : (T)result.get(0);
    }

    public <T> List<T> getResultList(Query q) {
        List resultList = q.getResultList();
        if (resultList != null) {
            for (Object result : resultList) {
                if (result instanceof Tenant) continue;
                TenancyUtils.checkTenantAccessForDbEntity(result, this.tenantId);
            }
        }
        return resultList;
    }

    public int executeUpdate(Query q) {
        int result = q.executeUpdate();
        this.entityMgr.clear();
        return result;
    }
}

