/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.Utils;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class MockProfileDao
extends AbstractDAO {
    public List<MockProfile> getAll(Integer loadCount, Integer lastLoadedId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from MOCK_PROFILE mp ");
        sql.append(" where tenant_id = :tenant_id ");
        if (loadCount != null || lastLoadedId != null) {
            sql.append(" where mp.MOCK_PROFILE_ID in ( ");
            sql.append("    select mp2.MOCK_PROFILE_ID from MOCK_PROFILE mp2 ");
            if (lastLoadedId != null) {
                sql.append("  where mp2.MOCK_PROFILE_ID < :last_load_id ");
            }
            sql.append("    order by mp2.MOCK_PROFILE_ID desc ");
            sql.append(" ) ");
            if (loadCount != null) {
                sql.append(" and ROWNUM() <= :load_count ");
            }
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), MockProfile.class);
        q.setParameter("tenant_id", (Object)this.tenantId);
        if (lastLoadedId != null) {
            q.setParameter("last_load_id", (Object)lastLoadedId);
        }
        if (loadCount != null) {
            q.setParameter("load_count", (Object)loadCount);
        }
        return q.getResultList();
    }

    public int getCount() {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(mock_profile_id) from mock_profile ");
        sql.append(" where tenant_id = :tenant_id ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("tenant_id", (Object)this.tenantId);
        return Utils.numberToInteger((Number)((Number)this.getSingleResult(q)));
    }

    public void clearAllNonPersistent() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from mock_profile where persistent = 0 ");
        if (this.tenantId != null) {
            sql.append(" and tenant_id = :tenant_id ");
            params.put("tenant_id", this.tenantId);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        this.executeUpdate(q);
    }

    public boolean existsByName(String name, Integer exceptID) {
        return this.getByName(name, exceptID) != null;
    }

    public MockProfile getByName(String name, Integer exceptID) {
        Objects.requireNonNull(name, "name");
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenant_id", this.tenantId);
        params.put("name", name.toUpperCase());
        sql.append(" select * from MOCK_PROFILE");
        sql.append(" where tenant_id = :tenant_id and UPPER(name) = :name ");
        if (exceptID != null) {
            sql.append(" and mock_profile_id != :id ");
            params.put("id", exceptID);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString(), MockProfile.class);
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        return (MockProfile)this.getSingleResult(q);
    }
}

