/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence.dao;

import de.joergdev.mosy.backend.persistence.dao.core.AbstractDAO;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.Objects;

public class MockDataDAO
extends AbstractDAO {
    public void increaseCountCalls(Integer id) {
        Objects.requireNonNull(id, "id");
        StringBuilder sql = new StringBuilder();
        sql.append(" update MOCK_DATA set COUNT_CALLS = COUNT_CALLS+1 where MOCK_DATA_ID = :id ");
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        q.setParameter("id", (Object)id);
        this.executeUpdate(q);
    }

    public void setValuesOnStartup() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append(" update MOCK_DATA set COUNT_CALLS = 0 ");
        if (this.tenantId != null) {
            sql.append(" where tenant_id = :tenant_id ");
            params.put("tenant_id", this.tenantId);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        this.executeUpdate(q);
    }

    public boolean existsByTitle(Integer interfaceMethodId, String title, Integer exceptID) {
        Objects.requireNonNull(interfaceMethodId, "interfaceMethodId");
        Objects.requireNonNull(title, "title");
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("im_id", interfaceMethodId);
        params.put("title", title);
        sql.append(" select 1 from MOCK_DATA ");
        sql.append(" where interface_method_id = :im_id ");
        sql.append(" and title = :title ");
        if (exceptID != null) {
            sql.append(" and mock_data_id != :id ");
            params.put("id", exceptID);
        }
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        return this.getSingleResult(q) != null;
    }

    public int deleteMockDataDedicatedForMockProfile(Integer mockProfileID) {
        Objects.requireNonNull(mockProfileID, "mockProfileID");
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from MOCK_DATA md ");
        sql.append(" where md.tenant_id = :tenant_id and md.COMMON = 0 ");
        sql.append(" and not exists ( ");
        sql.append("  select 1 from MOCK_DATA_MOCK_PROFILE mdmp ");
        sql.append("  where mdmp.MOCK_DATA_ID = md.MOCK_DATA_ID ");
        sql.append("  and mdmp.MOCK_PROFILE_ID != :mp_id ");
        sql.append(" ) ");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tenant_id", this.tenantId);
        params.put("mp_id", mockProfileID);
        Query q = this.entityMgr.createNativeQuery(sql.toString());
        params.entrySet().forEach(e -> q.setParameter((String)e.getKey(), e.getValue()));
        return q.executeUpdate();
    }
}

