/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.persistence;

import de.joergdev.mosy.backend.persistence.EntityManagerProvider;
import jakarta.persistence.EntityManager;
import java.util.Objects;

public class EntityManagerProviderService {
    private static final EntityManagerProviderService INSTANCE = new EntityManagerProviderService();
    private EntityManagerProvider entityManagerProvider;

    private EntityManagerProviderService() {
    }

    public static EntityManagerProviderService getInstance() {
        return INSTANCE;
    }

    public EntityManagerProvider getEntityManagerProvider() {
        return this.entityManagerProvider;
    }

    public void setEntityManagerProvider(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    public EntityManager getEntityManager() {
        Objects.requireNonNull(this.entityManagerProvider, "entityManagerProvider not set");
        return this.entityManagerProvider.getEntityManager();
    }

    public void releaseEntityManager(EntityManager em) {
        Objects.requireNonNull(this.entityManagerProvider, "entityManagerProvider not set");
        this.entityManagerProvider.releaseEntityManager(em);
    }

    public void rollbackEntityManager(EntityManager em) {
        Objects.requireNonNull(this.entityManagerProvider, "entityManagerProvider not set");
        this.entityManagerProvider.rollbackEntityManager(em);
    }

    public boolean isContainerManaged() {
        Objects.requireNonNull(this.entityManagerProvider, "entityManagerProvider not set");
        return this.entityManagerProvider.isContainerManaged();
    }
}

