/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.tenant;

import de.joergdev.mosy.api.request.tenant.SaveRequest;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.tenant.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.system.Boot;
import de.joergdev.mosy.backend.persistence.dao.TenantDao;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.security.TokenManagerService;
import de.joergdev.mosy.shared.Utils;

public class Save
extends AbstractBL<SaveRequest, SaveResponse> {
    private de.joergdev.mosy.api.model.Tenant apiTenant;
    private boolean creation;
    private Tenant dbTenant;

    @Override
    protected void beforeExecute() {
        if (((SaveRequest)this.request).getTenant() != null && ((SaveRequest)this.request).getTenant().getTenantId() == null) {
            this.checkToken = false;
        }
    }

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.apiTenant = ((SaveRequest)this.request).getTenant();
        this.leaveOn(this.apiTenant == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("tenant"));
        this.leaveOn(Utils.isEmpty((String)this.apiTenant.getName()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("tenant name"));
        this.leaveOn(this.apiTenant.getTenantId() == null && ((SaveRequest)this.request).getSecretHash() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("tenant secret"));
        this.leaveOn(((SaveRequest)this.request).getSecretHash() != null && ((SaveRequest)this.request).getSecretHash() == 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("tenant secret"));
    }

    @Override
    protected void execute() {
        this.loadOrCreateDbTenant();
        this.checkUniqueData();
        this.dbTenant.setName(this.apiTenant.getName());
        if (((SaveRequest)this.request).getSecretHash() != null) {
            this.dbTenant.setSecretHash(((SaveRequest)this.request).getSecretHash());
        }
        this.entityMgr.persist(this.dbTenant);
        this.entityMgr.flush();
        this.apiTenant.setTenantId(this.dbTenant.getTenantId());
        this.bootOnCreation();
    }

    private void bootOnCreation() {
        if (this.creation) {
            this.setToken(TokenManagerService.createToken(this.dbTenant.getSecretHash(), this.dbTenant.getTenantId(), this.dbTenant.getSecretHash(), null));
            this.invokeSubBL(new Boot(), null, new EmptyResponse());
        }
    }

    private void checkUniqueData() {
        this.leaveOn(this.getDao(TenantDao.class).existsByName(this.apiTenant.getName(), this.apiTenant.getTenantId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("tenant with name: " + this.apiTenant.getName()));
    }

    private void loadOrCreateDbTenant() {
        if (this.apiTenant.getTenantId() != null) {
            this.dbTenant = this.findDbEntity(Tenant.class, this.apiTenant.getTenantId(), "tenant with id " + this.apiTenant.getTenantId());
        } else {
            this.dbTenant = new Tenant();
            this.creation = true;
        }
    }

    @Override
    protected void fillOutput() {
        ((SaveResponse)this.response).setTenant(this.apiTenant);
    }
}

