/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.system;

import de.joergdev.mosy.api.request.system.LoginRequest;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.system.LoginResponse;
import de.joergdev.mosy.backend.Config;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.utils.TenancyUtils;
import de.joergdev.mosy.backend.persistence.dao.TenantDao;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.security.TokenManagerService;

public class Login
extends AbstractBL<LoginRequest, LoginResponse> {
    private String token;
    private final TenantData tenantData = new TenantData(this);

    @Override
    protected void beforeExecute() {
        this.checkToken = false;
    }

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(((LoginRequest)this.request).getSecretHash() == 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("secret"));
        this.leaveOn(Config.isMultiTenancyEnabled() && ((LoginRequest)this.request).getTenantId() == null && ((LoginRequest)this.request).getTenantName() == null || !Config.isMultiTenancyEnabled() && (((LoginRequest)this.request).getTenantId() != null || ((LoginRequest)this.request).getTenantName() != null), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("tenant"));
    }

    @Override
    protected void execute() {
        this.loadTenantDataIfIdOrNameSet();
        this.token = TokenManagerService.createToken(((LoginRequest)this.request).getSecretHash(), this.tenantData.tenantId, this.tenantData.tenantSecretHash, () -> TenancyUtils.getDefaultTenantIdForNonMultiTanency(this));
        this.leaveOn(this.token == null, ResponseCode.INVALID_CREDENTIALS);
    }

    private void loadTenantDataIfIdOrNameSet() {
        Integer tenantId = ((LoginRequest)this.request).getTenantId();
        String tenantName = ((LoginRequest)this.request).getTenantName();
        Tenant dbTenant = null;
        if (tenantId != null) {
            dbTenant = this.entityMgr.find(Tenant.class, tenantId);
            this.leaveOn(dbTenant == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("tenant"));
        } else if (tenantName != null) {
            dbTenant = this.getDao(TenantDao.class).getByName(tenantName, null);
            this.leaveOn(dbTenant == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("tenant"));
        }
        if (dbTenant != null) {
            this.tenantData.tenantId = dbTenant.getTenantId();
            this.tenantData.tenantSecretHash = dbTenant.getSecretHash();
        }
    }

    @Override
    protected void fillOutput() {
        ((LoginResponse)this.response).setToken(this.token);
    }

    private class TenantData {
        Integer tenantId = null;
        Integer tenantSecretHash = null;

        private TenantData(Login login) {
        }
    }
}

