/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.system;

import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceType;
import de.joergdev.mosy.api.response.system.LoadBaseDataResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.globalconfig.Load;
import de.joergdev.mosy.backend.persistence.dao.InterfaceDao;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.dao.RecordDAO;
import de.joergdev.mosy.backend.persistence.dao.RecordSessionDao;
import de.joergdev.mosy.shared.ObjectUtils;
import java.util.ArrayList;
import java.util.List;

public class LoadBaseData
extends AbstractBL<Void, LoadBaseDataResponse> {
    private BaseData baseDataGlobalConf;
    private int countRecordSessions = 0;
    private int countMockProfiles = 0;
    private int countRecords = 0;
    private final List<Interface> apiInterfaces = new ArrayList<Interface>();

    @Override
    protected void validateInput() {
    }

    @Override
    protected void execute() {
        this.baseDataGlobalConf = this.invokeSubBL(new Load(), null, new LoadBaseDataResponse()).getBaseData();
        this.loadInterfaces();
        this.countRecordSessions = this.getDao(RecordSessionDao.class).getCount();
        this.countMockProfiles = this.getDao(MockProfileDao.class).getCount();
        this.countRecords = this.getDao(RecordDAO.class).getCount();
    }

    private void loadInterfaces() {
        for (de.joergdev.mosy.backend.persistence.model.Interface dbInterface : this.getDao(InterfaceDao.class).getAll()) {
            Interface apiInterface = new Interface();
            this.apiInterfaces.add(apiInterface);
            ObjectUtils.copyValues((Object)dbInterface, (Object)apiInterface, (String[])new String[]{"type"});
            if (dbInterface.getType() != null) {
                apiInterface.setType(InterfaceType.getById((Integer)dbInterface.getType().getInterfaceTypeId()));
            } else {
                apiInterface.setType(null);
            }
            apiInterface.setRecord(dbInterface.getRecordConfig() == null || dbInterface.getRecordConfig().getEnabled() == null ? null : Boolean.valueOf(Boolean.TRUE.equals(dbInterface.getRecordConfig().getEnabled())));
        }
    }

    @Override
    protected void fillOutput() {
        BaseData baseData = new BaseData();
        ((LoadBaseDataResponse)this.response).setBaseData(baseData);
        ObjectUtils.copyValues((Object)this.baseDataGlobalConf, (Object)baseData, (String[])new String[0]);
        baseData.setCountRecordSessions(Integer.valueOf(this.countRecordSessions));
        baseData.setCountRecords(Integer.valueOf(this.countRecords));
        baseData.setCountMockProfiles(Integer.valueOf(this.countMockProfiles));
        baseData.getInterfaces().addAll(this.apiInterfaces);
    }
}

