/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.system;

import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.globalconfig.Save;
import de.joergdev.mosy.backend.bl.utils.TenancyUtils;
import de.joergdev.mosy.backend.persistence.dao.DbConfigDAO;
import de.joergdev.mosy.backend.persistence.dao.GlobalConfigDAO;
import de.joergdev.mosy.backend.persistence.dao.InterfaceDao;
import de.joergdev.mosy.backend.persistence.dao.InterfaceMethodDAO;
import de.joergdev.mosy.backend.persistence.dao.InterfaceTypeDao;
import de.joergdev.mosy.backend.persistence.dao.MigrationDao;
import de.joergdev.mosy.backend.persistence.dao.MockDataDAO;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.dao.RecordSessionDao;
import de.joergdev.mosy.backend.persistence.dao.TenantDao;
import de.joergdev.mosy.backend.persistence.model.DbConfig;
import de.joergdev.mosy.backend.persistence.model.GlobalConfig;
import de.joergdev.mosy.backend.persistence.model.InterfaceType;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.shared.Utils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Boot
extends AbstractBL<Void, EmptyResponse> {
    private static final Integer[] ACTUAL_VERSION = new Integer[]{5, 0, 0};
    private DbConfig dbConfig;

    @Override
    protected void validateInput() {
    }

    @Override
    protected void execute() {
        this.createDbConfigIfNotExisting();
        this.createDefaultTenantForNonMultiTanencyIfNotExisting();
        this.createInterfaceTypesIfNotExisting();
        this.createGlobalConfigIfNotExisting();
        this.getDao(GlobalConfigDAO.class).setValuesOnStartup();
        this.getDao(InterfaceDao.class).setValuesOnStartup();
        this.getDao(InterfaceMethodDAO.class).setValuesOnStartup();
        this.getDao(MockDataDAO.class).setValuesOnStartup();
        this.getDao(RecordSessionDao.class).clearAll();
        this.getDao(MockProfileDao.class).clearAllNonPersistent();
        this.doDbUpdate();
    }

    private void createDefaultTenantForNonMultiTanencyIfNotExisting() {
        if (!this.getDao(TenantDao.class).existsByName("Default non-multi-tanency", null)) {
            Tenant dbTenant = new Tenant();
            dbTenant.setName("Default non-multi-tanency");
            dbTenant.setSecretHash(123);
            this.entityMgr.persist(dbTenant);
            this.entityMgr.flush();
            this.createGlobalConfigIfNotExisting(dbTenant.getTenantId(), true);
        }
    }

    private void doDbUpdate() {
        if (this.getTenantId() != null) {
            return;
        }
        Integer[] schemaVersionDb = this.getSchemaVersionDb();
        String actualDbSchemaVersion = this.getDbSchemaVersionAsString(ACTUAL_VERSION);
        if (actualDbSchemaVersion.equals(this.getDbSchemaVersionAsString(schemaVersionDb))) {
            return;
        }
        for (Map.Entry<Integer[], Runnable> schemaUpdate : this.getDbUpdateImplementations().entrySet()) {
            if (!this.isUpdateVersionHigherThenActualVersion(schemaVersionDb, schemaUpdate.getKey())) continue;
            schemaUpdate.getValue().run();
        }
        this.dbConfig.setSchemaVersion(actualDbSchemaVersion);
        this.entityMgr.persist(this.dbConfig);
        this.entityMgr.flush();
    }

    private String getDbSchemaVersionAsString(Integer[] versionArr) {
        return Arrays.asList(versionArr).stream().map(i -> String.valueOf(i)).collect(Collectors.joining("."));
    }

    private Map<Integer[], Runnable> getDbUpdateImplementations() {
        HashMap<Integer[], Runnable> mapSchemaUpdates = new HashMap<Integer[], Runnable>();
        mapSchemaUpdates.put(new Integer[]{3, 0, 0}, () -> {
            MigrationDao migDao = this.getDao(MigrationDao.class);
            migDao.migrateServicePathIntern();
            migDao.setMockDataResponseNullable();
            migDao.setRecordRequestNullable();
            migDao.setRecordResponseNullable();
        });
        return mapSchemaUpdates;
    }

    private Integer[] getSchemaVersionDb() {
        String schemaVersion = this.dbConfig.getSchemaVersion();
        if (Utils.isEmpty((String)schemaVersion)) {
            schemaVersion = "0.0.0";
        }
        Integer[] schemaVersionDb = new Integer[3];
        int pos = 0;
        for (String v : schemaVersion.split(Pattern.quote("."))) {
            schemaVersionDb[pos] = Integer.valueOf(v);
            ++pos;
        }
        return schemaVersionDb;
    }

    private boolean isUpdateVersionHigherThenActualVersion(Integer[] schemaVersionDb, Integer[] versionUpdate) {
        if (schemaVersionDb[0] < versionUpdate[0]) {
            return true;
        }
        if (schemaVersionDb[0].equals(versionUpdate[0])) {
            if (schemaVersionDb[1] < versionUpdate[1]) {
                return true;
            }
            if (schemaVersionDb[1].equals(versionUpdate[1]) && schemaVersionDb[2] < versionUpdate[2]) {
                return true;
            }
        }
        return false;
    }

    private void createInterfaceTypesIfNotExisting() {
        if (this.getDao(InterfaceTypeDao.class).getCount() == 0) {
            for (de.joergdev.mosy.api.model.InterfaceType apiInterfaceType : de.joergdev.mosy.api.model.InterfaceType.values()) {
                InterfaceType dbInterfaceType = new InterfaceType();
                dbInterfaceType.setInterfaceTypeId(apiInterfaceType.id);
                dbInterfaceType.setName(apiInterfaceType.name());
                this.entityMgr.persist(dbInterfaceType);
            }
            this.entityMgr.flush();
        }
    }

    private void createDbConfigIfNotExisting() {
        this.dbConfig = this.getDao(DbConfigDAO.class).get();
        if (this.dbConfig == null) {
            this.dbConfig = new DbConfig();
            this.dbConfig.setCreated(LocalDateTime.now());
            this.dbConfig.setSchemaVersion(this.getDbSchemaVersionAsString(ACTUAL_VERSION));
            this.entityMgr.persist(this.dbConfig);
            this.entityMgr.flush();
            this.dbConfig = this.getDao(DbConfigDAO.class).get();
        }
    }

    private void createGlobalConfigIfNotExisting() {
        this.createGlobalConfigIfNotExisting(this.getTenantId(), false);
    }

    private void createGlobalConfigIfNotExisting(Integer tenantId, boolean ctxCreateDefaultTenantForNonMultiTanency) {
        GlobalConfig dbGlobalConfig;
        if (tenantId == null) {
            return;
        }
        GlobalConfigDAO dao = this.getDao(GlobalConfigDAO.class);
        if (ctxCreateDefaultTenantForNonMultiTanency) {
            dao.setTenantId(tenantId);
        }
        if ((dbGlobalConfig = dao.get()) == null) {
            BaseData apiBaseData = new BaseData();
            apiBaseData.setTtlMockProfile(Integer.valueOf(86400));
            apiBaseData.setTtlRecordSession(Integer.valueOf(86400));
            boolean resetToken = false;
            if (ctxCreateDefaultTenantForNonMultiTanency && this.getToken() == null) {
                TenancyUtils.setInternTokenForTenancy(this, tenantId);
                resetToken = true;
            }
            this.invokeSubBL(new Save(), apiBaseData, new EmptyResponse());
            if (resetToken) {
                this.setToken(null);
            }
        }
    }

    @Override
    protected void fillOutput() {
    }
}

