/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.recordconfig;

import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.recordconfig.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.utils.BlUtils;
import de.joergdev.mosy.backend.persistence.dao.RecordConfigDAO;
import de.joergdev.mosy.backend.persistence.model.Interface;
import de.joergdev.mosy.backend.persistence.model.InterfaceMethod;
import de.joergdev.mosy.backend.persistence.model.RecordConfig;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;

public class Save
extends AbstractBL<de.joergdev.mosy.api.model.RecordConfig, SaveResponse> {
    private Integer id;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        if (!this.isSubcall) {
            this.leaveOn(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockInterface"));
            this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.RecordConfig)this.request).getTitle()) || ((de.joergdev.mosy.api.model.RecordConfig)this.request).getTitle().length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("title"));
            this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("requestData"));
        }
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData()) && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData().length() > 500000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("requestData too long"));
        this.leaveOn(((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() != null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() != null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface and interfaceMethod may not be set at same time"));
        this.leaveOn(((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() == null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() == null && !Utils.isEmpty((String)((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("requestData must be null on global recordConfig"));
        this.leaveOn(((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() != null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface().getInterfaceId() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockInterfaceID"));
        this.leaveOn(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() != null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interfaceMethodID"));
    }

    @Override
    protected void execute() {
        RecordConfig dbRecordConfig = null;
        dbRecordConfig = ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId() != null ? this.findDbEntity(RecordConfig.class, ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId(), "recordConfig with id " + ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()) : new RecordConfig();
        this.checkUniqueData(dbRecordConfig);
        this.transferValues(dbRecordConfig);
        this.entityMgr.persist(dbRecordConfig);
        this.entityMgr.flush();
        this.id = dbRecordConfig.getRecordConfigId();
    }

    private void transferValues(RecordConfig dbRecordConfig) {
        if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() != null) {
            Integer dbInterfaceID;
            Integer reqInterfaceID = ((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface().getInterfaceId();
            Integer n = dbInterfaceID = dbRecordConfig.getMockInterface() == null ? null : dbRecordConfig.getMockInterface().getInterfaceId();
            if (!reqInterfaceID.equals(dbInterfaceID)) {
                dbRecordConfig.setMockInterface(this.findDbEntity(Interface.class, reqInterfaceID, "interface with id: " + reqInterfaceID));
            }
        } else {
            dbRecordConfig.setMockInterface(null);
        }
        if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() != null) {
            Integer dbMethodID;
            Integer reqMethodID = ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId();
            Integer n = dbMethodID = dbRecordConfig.getInterfaceMethod() == null ? null : dbRecordConfig.getInterfaceMethod().getInterfaceMethodId();
            if (!reqMethodID.equals(dbMethodID)) {
                dbRecordConfig.setInterfaceMethod(this.findDbEntity(InterfaceMethod.class, reqMethodID, "interface-method with id: " + reqMethodID));
            }
        } else {
            dbRecordConfig.setInterfaceMethod(null);
        }
        ((de.joergdev.mosy.api.model.RecordConfig)this.request).formatRequest(BlUtils.getInterfaceTypeId(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod(), dbRecordConfig.getInterfaceMethod()));
        ObjectUtils.copyValues((Object)this.request, (Object)dbRecordConfig, (String[])new String[]{"mockInterface", "interfaceMethod"});
    }

    private void checkUniqueData(RecordConfig dbRecordConfig) {
        if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() != null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getTitle() != null) {
            this.leaveOn(this.getDao(RecordConfigDAO.class).existsByTitle(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId(), ((de.joergdev.mosy.api.model.RecordConfig)this.request).getTitle(), ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("recordConfig with title: " + ((de.joergdev.mosy.api.model.RecordConfig)this.request).getTitle()));
        }
        if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() == null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() == null) {
            if (dbRecordConfig == null) {
                RecordConfig dbExisting = this.getDao(RecordConfigDAO.class).getGlobal();
                this.leaveOn(dbExisting != null && !dbExisting.getRecordConfigId().equals(((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("global recordConfig already exists with id: " + dbExisting.getRecordConfigId()));
            } else {
                this.leaveOn(dbRecordConfig.getMockInterface() != null || dbRecordConfig.getInterfaceMethod() != null, ResponseCode.OPERATION_FAILED_INFO.withAddtitionalInfo("cannot change recordConfig to global"));
            }
        } else if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() != null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() == null) {
            if (dbRecordConfig == null || dbRecordConfig.getRecordConfigId() == null) {
                RecordConfig dbExisting = this.getDao(RecordConfigDAO.class).getByInterfaceId(((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface().getInterfaceId());
                this.leaveOn(dbExisting != null && !dbExisting.getRecordConfigId().equals(((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()), () -> ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interface global recordConfig already exists with id: " + dbExisting.getRecordConfigId()));
            } else {
                this.leaveOn(dbRecordConfig.getMockInterface() == null || !dbRecordConfig.getMockInterface().getInterfaceId().equals(((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface().getInterfaceId()) || dbRecordConfig.getInterfaceMethod() != null, ResponseCode.OPERATION_FAILED_INFO.withAddtitionalInfo("cannot change recordConfig to interface global for interface with id " + ((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface().getInterfaceId()));
            }
        } else if (((de.joergdev.mosy.api.model.RecordConfig)this.request).getMockInterface() == null && ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod() != null) {
            if (Utils.isEmpty((String)((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData())) {
                if (dbRecordConfig == null || dbRecordConfig.getRecordConfigId() == null) {
                    RecordConfig dbExisting = this.getDao(RecordConfigDAO.class).getByInterfaceMethodId(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId());
                    this.leaveOn(dbExisting != null && !dbExisting.getRecordConfigId().equals(((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()), () -> ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interfaceMethod global recordConfig already exists with id: " + dbExisting.getRecordConfigId()));
                } else {
                    this.leaveOn(dbRecordConfig.getMockInterface() != null || dbRecordConfig.getInterfaceMethod() == null || !dbRecordConfig.getInterfaceMethod().getInterfaceMethodId().equals(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId()) || !Utils.isEmpty((String)dbRecordConfig.getRequestData()), ResponseCode.OPERATION_FAILED_INFO.withAddtitionalInfo("cannot change recordConfig to interfaceMethod global for interfaceMethod with id: " + ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId()));
                }
            } else {
                this.leaveOn(this.getDao(RecordConfigDAO.class).getByInterfaceMethodIdRequestData(((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId(), ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRequestData(), ((de.joergdev.mosy.api.model.RecordConfig)this.request).getRecordConfigId()) != null, ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("recordConfig with requestData for interfaceMethodID: " + ((de.joergdev.mosy.api.model.RecordConfig)this.request).getInterfaceMethod().getInterfaceMethodId()));
            }
        }
    }

    @Override
    protected void fillOutput() {
        ((SaveResponse)this.response).setRecordConfigID(this.id);
    }
}

