/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.record;

import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.record.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.utils.BlUtils;
import de.joergdev.mosy.backend.persistence.model.InterfaceMethod;
import de.joergdev.mosy.backend.persistence.model.InterfaceType;
import de.joergdev.mosy.backend.persistence.model.Record;
import de.joergdev.mosy.backend.persistence.model.RecordPathParam;
import de.joergdev.mosy.backend.persistence.model.RecordSession;
import de.joergdev.mosy.backend.persistence.model.RecordUrlArgument;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.time.LocalDateTime;

public class Save
extends AbstractBL<de.joergdev.mosy.api.model.Record, SaveResponse> {
    private Integer id;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod() == null || ((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod().getInterfaceMethodId() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method"));
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.Record)this.request).getRequestData()) && ((de.joergdev.mosy.api.model.Record)this.request).getRequestData().length() > 500000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request data length"));
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.Record)this.request).getResponse()) && ((de.joergdev.mosy.api.model.Record)this.request).getResponse().length() > 500000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("response data length"));
        this.leaveOn(((de.joergdev.mosy.api.model.Record)this.request).getRecordSession() != null && ((de.joergdev.mosy.api.model.Record)this.request).getRecordSession().getRecordSessionID() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("recordSession"));
    }

    @Override
    protected void execute() {
        Record dbRecord = this.getDbRecord();
        InterfaceMethod dbMethod = this.findDbEntity(InterfaceMethod.class, ((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod().getInterfaceMethodId(), "interface method with id " + ((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod().getInterfaceMethodId());
        this.validateAfterLoad(dbMethod);
        RecordSession dbRecordSession = this.getDbRecordSession();
        ((de.joergdev.mosy.api.model.Record)this.request).formatRequestResponse(BlUtils.getInterfaceTypeId(((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod(), dbMethod));
        ObjectUtils.copyValues((Object)this.request, (Object)dbRecord, (String[])new String[]{"interfaceMethod", "created", "recordSession", "pathParams", "urlArguments"});
        dbRecord.setInterfaceMethod(dbMethod);
        dbRecord.setRecordSession(dbRecordSession);
        this.entityMgr.persist(dbRecord);
        this.entityMgr.flush();
        this.id = dbRecord.getRecordId();
        this.savePathParams(dbRecord);
        this.saveUrlArguments(dbRecord);
    }

    private void validateAfterLoad(InterfaceMethod dbMethod) {
        this.checkInterfaceType(dbMethod);
        if (!de.joergdev.mosy.api.model.InterfaceType.REST.id.equals(BlUtils.getInterfaceTypeId(((de.joergdev.mosy.api.model.Record)this.request).getInterfaceMethod(), dbMethod))) {
            this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.Record)this.request).getRequestData()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request data"));
            this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.Record)this.request).getResponse()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("response"));
        }
    }

    private RecordSession getDbRecordSession() {
        if (((de.joergdev.mosy.api.model.Record)this.request).getRecordSession() != null) {
            return this.findDbEntity(RecordSession.class, ((de.joergdev.mosy.api.model.Record)this.request).getRecordSession().getRecordSessionID(), "recordSession with id: " + ((de.joergdev.mosy.api.model.Record)this.request).getRecordSession().getRecordSessionID());
        }
        return null;
    }

    private Record getDbRecord() {
        Record dbRecord = null;
        if (((de.joergdev.mosy.api.model.Record)this.request).getRecordId() != null) {
            dbRecord = this.findDbEntity(Record.class, ((de.joergdev.mosy.api.model.Record)this.request).getRecordId(), "record with id " + ((de.joergdev.mosy.api.model.Record)this.request).getRecordId());
        } else {
            dbRecord = new Record();
            dbRecord.setCreated(LocalDateTime.now());
        }
        return dbRecord;
    }

    private void savePathParams(Record dbRecord) {
        boolean dbChanged = false;
        for (RecordPathParam dbPathParam : Utils.nvlCollection(dbRecord.getPathParams())) {
            this.entityMgr.remove(this.entityMgr.find(RecordPathParam.class, dbPathParam.getRecordPathParamId()));
            dbChanged = true;
        }
        for (PathParam pathParam : ((de.joergdev.mosy.api.model.Record)this.request).getPathParams()) {
            RecordPathParam dbPathParam = new RecordPathParam();
            dbPathParam.setKey(pathParam.getKey());
            dbPathParam.setValue(pathParam.getValue());
            dbPathParam.setRecord(dbRecord);
            this.entityMgr.persist(dbPathParam);
            dbChanged = true;
        }
        if (dbChanged) {
            this.entityMgr.flush();
        }
    }

    private void saveUrlArguments(Record dbRecord) {
        boolean dbChanged = false;
        for (RecordUrlArgument dbUrlArg : Utils.nvlCollection(dbRecord.getUrlArguments())) {
            this.entityMgr.remove(this.entityMgr.find(RecordUrlArgument.class, dbUrlArg.getRecordUrlArgumentId()));
            dbChanged = true;
        }
        for (UrlArgument urlArg : ((de.joergdev.mosy.api.model.Record)this.request).getUrlArguments()) {
            RecordUrlArgument dbUrlArg = new RecordUrlArgument();
            dbUrlArg.setKey(urlArg.getKey());
            dbUrlArg.setValue(urlArg.getValue());
            dbUrlArg.setRecord(dbRecord);
            this.entityMgr.persist(dbUrlArg);
            dbChanged = true;
        }
        if (dbChanged) {
            this.entityMgr.flush();
        }
    }

    private void checkInterfaceType(InterfaceMethod dbMethod) {
        if (!this.isSubcall) {
            InterfaceType dbInterfaceType = dbMethod.getMockInterface().getType();
            this.leaveOn(!de.joergdev.mosy.api.model.InterfaceType.isCustomType((Integer)dbInterfaceType.getInterfaceTypeId()), ResponseCode.OPERATION_NOT_POSSIBLE.withAddtitionalInfo("record can only be saved for custom interfaces"));
        }
    }

    @Override
    protected void fillOutput() {
        ((SaveResponse)this.response).setRecordID(this.id);
    }
}

