/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockprofile;

import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.mockprofile.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.time.LocalDateTime;

public class Save
extends AbstractBL<de.joergdev.mosy.api.model.MockProfile, SaveResponse> {
    private MockProfile dbMockProfile;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.MockProfile)this.request).getName()) || ((de.joergdev.mosy.api.model.MockProfile)this.request).getName().length() > 200 || Utils.isNumeric((String)((de.joergdev.mosy.api.model.MockProfile)this.request).getName()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("name"));
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.MockProfile)this.request).getDescription()) && ((de.joergdev.mosy.api.model.MockProfile)this.request).getDescription().length() > 2000, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("response"));
    }

    @Override
    protected void execute() {
        this.loadOrCreateDbMockData();
        this.checkUniqueData();
        ObjectUtils.copyValues((Object)this.request, (Object)this.dbMockProfile, (String[])new String[]{"created"});
        this.entityMgr.persist(this.dbMockProfile);
        this.entityMgr.flush();
    }

    private void loadOrCreateDbMockData() {
        if (((de.joergdev.mosy.api.model.MockProfile)this.request).getMockProfileID() != null) {
            this.dbMockProfile = this.findDbEntity(MockProfile.class, ((de.joergdev.mosy.api.model.MockProfile)this.request).getMockProfileID(), "mockProfile with id " + ((de.joergdev.mosy.api.model.MockProfile)this.request).getMockProfileID());
        } else {
            this.dbMockProfile = new MockProfile();
            this.dbMockProfile.setCreated(LocalDateTime.now());
        }
    }

    private void checkUniqueData() {
        this.leaveOn(this.getDao(MockProfileDao.class).existsByName(((de.joergdev.mosy.api.model.MockProfile)this.request).getName(), ((de.joergdev.mosy.api.model.MockProfile)this.request).getMockProfileID()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("mockProfile with name: " + ((de.joergdev.mosy.api.model.MockProfile)this.request).getName()));
    }

    @Override
    protected void fillOutput() {
        de.joergdev.mosy.api.model.MockProfile apiMockProfileResponse = new de.joergdev.mosy.api.model.MockProfile();
        ObjectUtils.copyValues((Object)this.dbMockProfile, (Object)apiMockProfileResponse, (String[])new String[]{"created"});
        apiMockProfileResponse.setCreatedAsLdt(this.dbMockProfile.getCreated());
        ((SaveResponse)this.response).setMockProfile(apiMockProfileResponse);
    }
}

