/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockprofile;

import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.mockprofile.LoadMockDataResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.model.MockData;
import de.joergdev.mosy.backend.persistence.model.MockDataMockProfile;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadMockData
extends AbstractBL<de.joergdev.mosy.api.model.MockProfile, LoadMockDataResponse> {
    private final List<de.joergdev.mosy.api.model.MockData> apiMockDataList = new ArrayList<de.joergdev.mosy.api.model.MockData>();
    private Integer id;
    private String name;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockProfile"));
        this.id = ((de.joergdev.mosy.api.model.MockProfile)this.request).getMockProfileID();
        this.leaveOn(this.id != null && !Utils.isPositive((Number)this.id), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockProfileID"));
        this.name = ((de.joergdev.mosy.api.model.MockProfile)this.request).getName();
        this.leaveOn(this.id == null && Utils.isEmpty((String)this.name), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("mockProfileID / name"));
    }

    @Override
    protected void execute() {
        MockProfile dbMockProfile = null;
        if (this.id != null) {
            dbMockProfile = this.findDbEntity(MockProfile.class, this.request, "mockProfile with id " + this.id);
        } else {
            dbMockProfile = this.getDao(MockProfileDao.class).getByName(this.name, null);
            this.leaveOn(dbMockProfile == null, ResponseCode.DATA_DOESNT_EXIST.withAddtitionalInfo("mockProfile with name " + this.name));
            ((de.joergdev.mosy.api.model.MockProfile)this.request).setMockProfileID(dbMockProfile.getMockProfileID());
        }
        List<MockDataMockProfile> dbMockDataMockProfiles = dbMockProfile.getMockData();
        for (MockDataMockProfile dbMockDataMockProfile : Utils.nvlCollection(dbMockDataMockProfiles)) {
            MockData dbMockData = dbMockDataMockProfile.getMockData();
            de.joergdev.mosy.api.model.MockData apiMockData = new de.joergdev.mosy.api.model.MockData();
            ObjectUtils.copyValues((Object)dbMockData, (Object)apiMockData, (String[])new String[]{"created", "interfaceMethod", "request", "response", "mockProfiles"});
            apiMockData.setCreatedAsLdt(dbMockData.getCreated());
            InterfaceMethod apiInterfaceMethod = new InterfaceMethod();
            apiInterfaceMethod.setInterfaceMethodId(dbMockData.getInterfaceMethod().getInterfaceMethodId());
            apiMockData.setInterfaceMethod(apiInterfaceMethod);
            apiMockData.getMockProfiles().add((de.joergdev.mosy.api.model.MockProfile)this.request);
            this.apiMockDataList.add(apiMockData);
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadMockDataResponse)this.response).getMockData().addAll(this.apiMockDataList);
    }
}

