/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockprofile;

import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.mockprofile.LoadAllResponse;
import de.joergdev.mosy.backend.api.intern.request.mockprofile.LoadAllRequest;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.dao.MockProfileDao;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadAll
extends AbstractBL<LoadAllRequest, LoadAllResponse> {
    private final List<de.joergdev.mosy.api.model.MockProfile> apiMockProfiles = new ArrayList<de.joergdev.mosy.api.model.MockProfile>();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(((LoadAllRequest)this.request).getLoadCount() != null && ((LoadAllRequest)this.request).getLoadCount() <= 0, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("loadCount"));
        this.leaveOn(((LoadAllRequest)this.request).getLastLoadedId() != null && !Utils.isPositive((Number)((LoadAllRequest)this.request).getLastLoadedId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("lastLoadedId"));
    }

    @Override
    protected void execute() {
        List<MockProfile> dbMockProfiles = this.getDao(MockProfileDao.class).getAll(((LoadAllRequest)this.request).getLoadCount(), ((LoadAllRequest)this.request).getLastLoadedId());
        for (MockProfile dbMockProfile : Utils.nvlCollection(dbMockProfiles)) {
            de.joergdev.mosy.api.model.MockProfile apiMockProfile = new de.joergdev.mosy.api.model.MockProfile();
            ObjectUtils.copyValues((Object)dbMockProfile, (Object)apiMockProfile, (String[])new String[]{"created"});
            apiMockProfile.setCreatedAsLdt(dbMockProfile.getCreated());
            this.apiMockProfiles.add(apiMockProfile);
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadAllResponse)this.response).getMockProfiles().addAll(this.apiMockProfiles);
    }
}

