/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.mockdata;

import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.mockdata.LoadResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.model.MockData;
import de.joergdev.mosy.backend.persistence.model.MockDataMockProfile;
import de.joergdev.mosy.backend.persistence.model.MockDataPathParam;
import de.joergdev.mosy.backend.persistence.model.MockDataUrlArgument;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;

public class Load
extends AbstractBL<Integer, LoadResponse> {
    private final de.joergdev.mosy.api.model.MockData apiMockData = new de.joergdev.mosy.api.model.MockData();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null || !Utils.isPositive((Number)((Number)this.request)), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("id"));
    }

    @Override
    protected void execute() {
        MockData dbMockData = this.findDbEntity(MockData.class, this.request, "mockData with id " + String.valueOf(this.request));
        ObjectUtils.copyValues((Object)dbMockData, (Object)this.apiMockData, (String[])new String[]{"created", "interfaceMethod", "mockProfiles"});
        this.apiMockData.setCreatedAsLdt(dbMockData.getCreated());
        if (dbMockData.getInterfaceMethod() != null) {
            InterfaceMethod apiMethod = new InterfaceMethod();
            apiMethod.setInterfaceMethodId(dbMockData.getInterfaceMethod().getInterfaceMethodId());
            this.apiMockData.setInterfaceMethod(apiMethod);
        }
        for (MockDataMockProfile dbMockDataMockProfiles : dbMockData.getMockProfiles()) {
            MockProfile dbMockProfile = dbMockDataMockProfiles.getMockProfile();
            de.joergdev.mosy.api.model.MockProfile apiMockProfile = new de.joergdev.mosy.api.model.MockProfile();
            ObjectUtils.copyValues((Object)dbMockProfile, (Object)apiMockProfile, (String[])new String[]{"created"});
            apiMockProfile.setCreatedAsLdt(dbMockProfile.getCreated());
            this.apiMockData.getMockProfiles().add(apiMockProfile);
        }
        for (MockDataPathParam dbPathParam : dbMockData.getPathParams()) {
            this.apiMockData.getPathParams().add(new PathParam(dbPathParam.getKey(), dbPathParam.getValue()));
        }
        for (MockDataUrlArgument dbUrlArg : dbMockData.getUrlArguments()) {
            this.apiMockData.getUrlArguments().add(new UrlArgument(dbUrlArg.getKey(), dbUrlArg.getValue()));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadResponse)this.response).setMockData(this.apiMockData);
    }
}

