/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.globalconfig;

import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.recordconfig.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.recordconfig.Delete;
import de.joergdev.mosy.backend.persistence.dao.GlobalConfigDAO;
import de.joergdev.mosy.backend.persistence.dao.RecordConfigDAO;
import de.joergdev.mosy.backend.persistence.model.GlobalConfig;
import de.joergdev.mosy.backend.persistence.model.RecordConfig;
import java.time.LocalDateTime;

public class Save
extends AbstractBL<BaseData, EmptyResponse> {
    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
    }

    @Override
    protected void execute() {
        GlobalConfig dbGlobalConfig = this.getDao(GlobalConfigDAO.class).get();
        if (dbGlobalConfig == null) {
            dbGlobalConfig = new GlobalConfig();
            dbGlobalConfig.setCreated(LocalDateTime.now());
        }
        dbGlobalConfig.setRoutingOnNoMockData(((BaseData)this.request).getRoutingOnNoMockData());
        dbGlobalConfig.setMockActive(((BaseData)this.request).getMockActive());
        dbGlobalConfig.setMockActiveOnStartup(((BaseData)this.request).getMockActiveOnStartup());
        dbGlobalConfig.setTtlMockProfile(((BaseData)this.request).getTtlMockProfile());
        dbGlobalConfig.setTtlRecordSession(((BaseData)this.request).getTtlRecordSession());
        this.entityMgr.persist(dbGlobalConfig);
        this.entityMgr.flush();
        this.saveRecordConfig();
    }

    private void saveRecordConfig() {
        RecordConfig dbRecordConfig = this.getDao(RecordConfigDAO.class).getGlobal();
        if (((BaseData)this.request).getRecord() == null) {
            if (dbRecordConfig != null) {
                this.invokeSubBL(new Delete(), dbRecordConfig.getRecordConfigId(), new EmptyResponse());
            }
        } else {
            de.joergdev.mosy.api.model.RecordConfig apiRecordConfig = new de.joergdev.mosy.api.model.RecordConfig();
            if (dbRecordConfig != null) {
                apiRecordConfig.setRecordConfigId(dbRecordConfig.getRecordConfigId());
            }
            apiRecordConfig.setEnabled(((BaseData)this.request).getRecord());
            this.invokeSubBL(new de.joergdev.mosy.backend.bl.recordconfig.Save(), apiRecordConfig, new SaveResponse());
        }
    }

    @Override
    protected void fillOutput() {
    }
}

