/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl.core;

import de.joergdev.mosy.backend.bl.utils.TenancyUtils;
import de.joergdev.mosy.backend.persistence.model.Tenant;
import de.joergdev.mosy.backend.persistence.model.TenantScoped;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;
import java.util.Map;

public class BLEntityManager
implements EntityManager {
    private final EntityManager delegate;
    private final Integer tenantId;

    public BLEntityManager(EntityManager delegate, Integer tenantId) {
        this.delegate = delegate;
        this.tenantId = tenantId;
    }

    private Tenant getTenant() {
        if (this.tenantId != null) {
            Tenant tenant = new Tenant();
            tenant.setTenantId(this.tenantId);
            return tenant;
        }
        return null;
    }

    private void setTenantForTenantScopedEntity(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        if (entity instanceof TenantScoped && ((TenantScoped)entity).getTenant() == null) {
            ((TenantScoped)entity).setTenant(this.getTenant());
        }
    }

    public void persist(Object entity) {
        this.setTenantForTenantScopedEntity(entity);
        this.delegate.persist(entity);
    }

    public <T> T merge(T entity) {
        this.setTenantForTenantScopedEntity(entity);
        return (T)this.delegate.merge(entity);
    }

    public void remove(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.find(entityClass, primaryKey), this.tenantId);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.find(entityClass, primaryKey, properties), this.tenantId);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.find(entityClass, primaryKey, lockMode), this.tenantId);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.find(entityClass, primaryKey, lockMode, properties), this.tenantId);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.getReference(entityClass, primaryKey), this.tenantId);
    }

    public void flush() {
        this.delegate.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.delegate.clear();
    }

    public void detach(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        this.delegate.detach(entity);
    }

    public boolean contains(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        return this.delegate.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        TenancyUtils.checkTenantAccessForDbEntity(entity, this.tenantId);
        return this.delegate.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.delegate.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    public Query createQuery(String qlString) {
        return this.delegate.createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.delegate.createQuery(criteriaQuery);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.delegate.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.delegate.createQuery(deleteQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.delegate.createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        return this.delegate.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.delegate.createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.delegate.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.delegate.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.delegate.createNativeQuery(sqlString, resultSetMapping);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.delegate.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.delegate.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.delegate.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.delegate.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public void joinTransaction() {
        this.delegate.joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.delegate.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)TenancyUtils.checkTenantAccessForDbEntity(this.delegate.unwrap(cls), this.tenantId);
    }

    public Object getDelegate() {
        return this.delegate.getDelegate();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.delegate.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.delegate.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.delegate.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.delegate.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.delegate.getEntityGraphs(entityClass);
    }
}

