/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl._interface.method;

import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response._interface.method.LoadRecordConfigsResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.model.RecordConfig;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadRecordConfigs
extends AbstractBL<InterfaceMethod, LoadRecordConfigsResponse> {
    private final List<de.joergdev.mosy.api.model.RecordConfig> recordConfigList = new ArrayList<de.joergdev.mosy.api.model.RecordConfig>();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(((InterfaceMethod)this.request).getInterfaceMethodId() == null || !Utils.isPositive((Number)((InterfaceMethod)this.request).getInterfaceMethodId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("id"));
        this.leaveOn(((InterfaceMethod)this.request).getMockInterface() != null && ((InterfaceMethod)this.request).getMockInterface().getInterfaceId() != null && !Utils.isPositive((Number)((InterfaceMethod)this.request).getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interfaceId"));
    }

    @Override
    protected void execute() {
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.InterfaceMethod.class, ((InterfaceMethod)this.request).getInterfaceMethodId(), "interface method with id " + ((InterfaceMethod)this.request).getInterfaceMethodId());
        this.checkInterface(dbMethod);
        for (RecordConfig dbRecordConf : dbMethod.getRecordConfig()) {
            if (dbRecordConf.getRequestData() == null) continue;
            de.joergdev.mosy.api.model.RecordConfig apiRecordConf = new de.joergdev.mosy.api.model.RecordConfig();
            apiRecordConf.setInterfaceMethod((InterfaceMethod)this.request);
            ObjectUtils.copyValues((Object)dbRecordConf, (Object)apiRecordConf, (String[])new String[]{"requestData", "mockInterface", "interfaceMethod"});
            this.recordConfigList.add(apiRecordConf);
        }
    }

    private void checkInterface(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        Interface apiInterface = ((InterfaceMethod)this.request).getMockInterface();
        if (apiInterface != null) {
            Integer interfaceId = apiInterface.getInterfaceId();
            this.leaveOn(interfaceId != null && !interfaceId.equals(dbMethod.getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method with id " + ((InterfaceMethod)this.request).getInterfaceMethodId() + " not exisiting for interface with id " + interfaceId));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadRecordConfigsResponse)this.response).getRecordConfigs().addAll(this.recordConfigList);
    }
}

