/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl._interface.method;

import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.model.MockData;
import de.joergdev.mosy.api.model.PathParam;
import de.joergdev.mosy.api.model.UrlArgument;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response._interface.method.LoadMockDataResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.persistence.model.MockDataMockProfile;
import de.joergdev.mosy.backend.persistence.model.MockDataPathParam;
import de.joergdev.mosy.backend.persistence.model.MockDataUrlArgument;
import de.joergdev.mosy.backend.persistence.model.MockProfile;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;

public class LoadMockData
extends AbstractBL<InterfaceMethod, LoadMockDataResponse> {
    private final List<MockData> mockDataList = new ArrayList<MockData>();

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(((InterfaceMethod)this.request).getInterfaceMethodId() == null || !Utils.isPositive((Number)((InterfaceMethod)this.request).getInterfaceMethodId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("id"));
        this.leaveOn(((InterfaceMethod)this.request).getMockInterface() != null && ((InterfaceMethod)this.request).getMockInterface().getInterfaceId() != null && !Utils.isPositive((Number)((InterfaceMethod)this.request).getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interfaceId"));
    }

    @Override
    protected void execute() {
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.InterfaceMethod.class, ((InterfaceMethod)this.request).getInterfaceMethodId(), "interface method with id " + ((InterfaceMethod)this.request).getInterfaceMethodId());
        this.checkInterface(dbMethod);
        InterfaceMethod apiMethod = new InterfaceMethod();
        apiMethod.setInterfaceMethodId(((InterfaceMethod)this.request).getInterfaceMethodId());
        this.transferMockProfiles(dbMethod, apiMethod);
    }

    private void transferMockProfiles(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod, InterfaceMethod apiMethod) {
        for (de.joergdev.mosy.backend.persistence.model.MockData dbMockData : dbMethod.getMockData()) {
            MockData apiMockData = new MockData();
            ObjectUtils.copyValues((Object)dbMockData, (Object)apiMockData, (String[])new String[]{"request", "response", "created", "interfaceMethod", "mockProfiles"});
            apiMockData.setCreatedAsLdt(dbMockData.getCreated());
            apiMockData.setInterfaceMethod(apiMethod);
            for (MockDataMockProfile dbMockDataMockProfile : dbMockData.getMockProfiles()) {
                MockProfile dbMockProfile = dbMockDataMockProfile.getMockProfile();
                de.joergdev.mosy.api.model.MockProfile apiMockProfile = new de.joergdev.mosy.api.model.MockProfile();
                ObjectUtils.copyValues((Object)dbMockProfile, (Object)apiMockProfile, (String[])new String[]{"created"});
                apiMockProfile.setCreatedAsLdt(dbMockProfile.getCreated());
                apiMockData.getMockProfiles().add(apiMockProfile);
            }
            for (MockDataPathParam dbPathParams : dbMockData.getPathParams()) {
                apiMockData.getPathParams().add(new PathParam(dbPathParams.getKey(), dbPathParams.getValue()));
            }
            for (MockDataUrlArgument dbUrlArg : dbMockData.getUrlArguments()) {
                apiMockData.getUrlArguments().add(new UrlArgument(dbUrlArg.getKey(), dbUrlArg.getValue()));
            }
            this.mockDataList.add(apiMockData);
        }
    }

    private void checkInterface(de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        Interface apiInterface = ((InterfaceMethod)this.request).getMockInterface();
        if (apiInterface != null) {
            Integer interfaceId = apiInterface.getInterfaceId();
            this.leaveOn(interfaceId != null && !interfaceId.equals(dbMethod.getMockInterface().getInterfaceId()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("interface method with id " + ((InterfaceMethod)this.request).getInterfaceMethodId() + " not exisiting for interface with id " + interfaceId));
        }
    }

    @Override
    protected void fillOutput() {
        ((LoadMockDataResponse)this.response).getMockData().addAll(this.mockDataList);
    }
}

