/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.bl._interface;

import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.InterfaceMethod;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.ResponseCode;
import de.joergdev.mosy.api.response.recordconfig.SaveResponse;
import de.joergdev.mosy.backend.bl.core.AbstractBL;
import de.joergdev.mosy.backend.bl.recordconfig.Delete;
import de.joergdev.mosy.backend.persistence.dao.InterfaceDao;
import de.joergdev.mosy.backend.persistence.dao.InterfaceMethodDAO;
import de.joergdev.mosy.backend.persistence.dao.RecordConfigDAO;
import de.joergdev.mosy.backend.persistence.model.Interface;
import de.joergdev.mosy.backend.persistence.model.InterfaceType;
import de.joergdev.mosy.backend.persistence.model.RecordConfig;
import de.joergdev.mosy.backend.util.MockServicesUtil;
import de.joergdev.mosy.shared.ObjectUtils;
import de.joergdev.mosy.shared.Utils;

public class Save
extends AbstractBL<de.joergdev.mosy.api.model.Interface, de.joergdev.mosy.api.response._interface.SaveResponse> {
    private Interface dbInterface;
    private Integer id;

    @Override
    protected void validateInput() {
        this.leaveOn(this.request == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("request"));
        this.leaveOn(Utils.isEmpty((String)((de.joergdev.mosy.api.model.Interface)this.request).getName()) || ((de.joergdev.mosy.api.model.Interface)this.request).getName().length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("name"));
        this.leaveOn(((de.joergdev.mosy.api.model.Interface)this.request).getType() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("type"));
        this.leaveOn(Boolean.TRUE.equals(((de.joergdev.mosy.api.model.Interface)this.request).getRoutingOnNoMockData()) && ((de.joergdev.mosy.api.model.Interface)this.request).getType().directRoutingPossible && Utils.isEmpty((String)((de.joergdev.mosy.api.model.Interface)this.request).getRoutingUrl()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("routingURL"));
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.Interface)this.request).getRoutingUrl()) && !((de.joergdev.mosy.api.model.Interface)this.request).getType().directRoutingPossible, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("routingURL not allowed"));
        this.leaveOn(!Utils.isEmpty((String)((de.joergdev.mosy.api.model.Interface)this.request).getRoutingUrl()) && ((de.joergdev.mosy.api.model.Interface)this.request).getRoutingUrl().length() > 500, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("routingURL"));
        String servicePath = ((de.joergdev.mosy.api.model.Interface)this.request).getServicePath();
        if (!Utils.isEmpty((String)servicePath)) {
            this.leaveOn(servicePath.length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("service path"));
            this.leaveOn(de.joergdev.mosy.api.model.InterfaceType.REST.equals((Object)((de.joergdev.mosy.api.model.Interface)this.request).getType()) && (servicePath.contains("{") || servicePath.contains("}")), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("service path"));
        }
        for (InterfaceMethod method : ((de.joergdev.mosy.api.model.Interface)this.request).getMethods()) {
            this.leaveOn(method.isDelete() && method.getInterfaceMethodId() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("method delete set but not id. Name: " + method.getName()));
            this.leaveOn(!method.isDelete() && Utils.isEmpty((String)method.getName()), ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("method name may not be empty. ID: " + method.getInterfaceMethodId()));
            this.leaveOn(!Utils.isEmpty((String)method.getName()) && method.getName().length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("method name too long: " + method.getName()));
            this.leaveOn(!Utils.isEmpty((String)method.getServicePath()) && method.getServicePath().length() > 200, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("method service path too long: " + method.getName()));
            this.leaveOn(!method.isDelete() && de.joergdev.mosy.api.model.InterfaceType.REST.equals((Object)((de.joergdev.mosy.api.model.Interface)this.request).getType()) && method.getHttpMethod() == null, ResponseCode.INVALID_INPUT_PARAMS.withAddtitionalInfo("httpMethod"));
        }
    }

    @Override
    protected void execute() {
        this.id = ((de.joergdev.mosy.api.model.Interface)this.request).getInterfaceId();
        de.joergdev.mosy.api.model.RecordConfig apiRecordConfig = new de.joergdev.mosy.api.model.RecordConfig();
        this.dbInterface = this.loadOrCreateDbInterface(apiRecordConfig);
        this.formatServicePath();
        this.checkUniqueDataInterface();
        this.apiInterface2dbInterface();
        this.entityMgr.persist(this.dbInterface);
        this.entityMgr.flush();
        this.id = this.dbInterface.getInterfaceId();
        ((de.joergdev.mosy.api.model.Interface)this.request).setInterfaceId(this.id);
        this.saveMethods();
        this.saveRecordConfig(apiRecordConfig, (de.joergdev.mosy.api.model.Interface)this.request, null, ((de.joergdev.mosy.api.model.Interface)this.request).getRecord());
    }

    private void apiInterface2dbInterface() {
        ObjectUtils.copyValues((Object)this.request, (Object)this.dbInterface, (String[])new String[]{"type", "methods"});
        if (((de.joergdev.mosy.api.model.Interface)this.request).getType() != null) {
            Integer dbTypID;
            Integer reqTypID = ((de.joergdev.mosy.api.model.Interface)this.request).getType().id;
            Integer n = dbTypID = this.dbInterface.getType() == null ? null : this.dbInterface.getType().getInterfaceTypeId();
            if (!reqTypID.equals(dbTypID)) {
                this.dbInterface.setType(this.entityMgr.find(InterfaceType.class, reqTypID));
            }
        } else {
            this.dbInterface.setType(null);
        }
    }

    private void formatServicePath() {
        if (de.joergdev.mosy.api.model.InterfaceType.isCustomType((de.joergdev.mosy.api.model.InterfaceType)((de.joergdev.mosy.api.model.Interface)this.request).getType())) {
            this.formatServicePathCustom();
        } else if (de.joergdev.mosy.api.model.InterfaceType.REST.equals((Object)((de.joergdev.mosy.api.model.Interface)this.request).getType())) {
            this.formatServicePathRest();
        }
    }

    private void formatServicePathRest() {
        ((de.joergdev.mosy.api.model.Interface)this.request).setServicePath(this.formatServicePath(((de.joergdev.mosy.api.model.Interface)this.request).getServicePath()));
        for (InterfaceMethod apiMethod : ((de.joergdev.mosy.api.model.Interface)this.request).getMethods()) {
            if (apiMethod.isDelete()) continue;
            apiMethod.setServicePath(this.formatServicePath(apiMethod.getServicePath()));
        }
    }

    private String formatServicePath(String servicePath) {
        if (servicePath != null) {
            if ((servicePath = servicePath.trim()).startsWith("http")) {
                servicePath = servicePath.substring(servicePath.indexOf("//") + 2);
            }
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
            if (servicePath.endsWith("/")) {
                servicePath = servicePath.substring(0, servicePath.length() - 1);
            }
        }
        return servicePath;
    }

    private void formatServicePathCustom() {
        ((de.joergdev.mosy.api.model.Interface)this.request).setServicePath(((de.joergdev.mosy.api.model.Interface)this.request).getName());
        for (InterfaceMethod apiMethod : ((de.joergdev.mosy.api.model.Interface)this.request).getMethods()) {
            if (apiMethod.isDelete()) continue;
            apiMethod.setServicePath(apiMethod.getName());
        }
    }

    private Interface loadOrCreateDbInterface(de.joergdev.mosy.api.model.RecordConfig apiRecordConfig) {
        Interface dbInterface;
        if (this.id != null) {
            dbInterface = this.findDbEntity(Interface.class, this.id, "no interface with id: " + this.id + ", name: " + ((de.joergdev.mosy.api.model.Interface)this.request).getName());
            RecordConfig dbRecordConfig = dbInterface.getRecordConfig();
            if (dbRecordConfig != null) {
                apiRecordConfig.setRecordConfigId(dbRecordConfig.getRecordConfigId());
                apiRecordConfig.setEnabled(dbRecordConfig.getEnabled());
            }
        } else {
            dbInterface = new Interface();
        }
        return dbInterface;
    }

    private void checkUniqueDataInterface() {
        this.leaveOn(this.getDao(InterfaceDao.class).existsByName(((de.joergdev.mosy.api.model.Interface)this.request).getName(), this.id), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interface with name: " + ((de.joergdev.mosy.api.model.Interface)this.request).getName()));
        this.leaveOn(((de.joergdev.mosy.api.model.Interface)this.request).getServicePath() != null && this.getDao(InterfaceDao.class).existsByServicePath(((de.joergdev.mosy.api.model.Interface)this.request).getServicePath(), de.joergdev.mosy.api.model.InterfaceType.REST.equals((Object)((de.joergdev.mosy.api.model.Interface)this.request).getType()), this.id), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interface with service path: " + ((de.joergdev.mosy.api.model.Interface)this.request).getServicePath()));
    }

    private void saveMethods() {
        for (InterfaceMethod apiMethod : ((de.joergdev.mosy.api.model.Interface)this.request).getMethods()) {
            de.joergdev.mosy.api.model.RecordConfig apiRecordConfig = new de.joergdev.mosy.api.model.RecordConfig();
            de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod = this.loadOrCreateDbMethod(this.dbInterface, apiMethod, apiRecordConfig);
            if (apiMethod.isDelete()) {
                this.entityMgr.remove(dbMethod);
                this.entityMgr.flush();
                continue;
            }
            this.checkUniqueDataInterfaceMethod(apiMethod);
            ObjectUtils.copyValues((Object)apiMethod, (Object)dbMethod, (String[])new String[]{"mockInterface", "mockData", "recordConfigs", "httpMethod"});
            this.setMethodHttpMethod(apiMethod, dbMethod);
            this.setMethodServicePathIntern(apiMethod, dbMethod);
            this.entityMgr.persist(dbMethod);
            this.entityMgr.flush();
            apiMethod.setInterfaceMethodId(dbMethod.getInterfaceMethodId());
            this.saveRecordConfig(apiRecordConfig, null, apiMethod, apiMethod.getRecord());
        }
    }

    private void setMethodServicePathIntern(InterfaceMethod apiMethod, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        if (de.joergdev.mosy.api.model.InterfaceType.REST.equals((Object)((de.joergdev.mosy.api.model.Interface)this.request).getType())) {
            dbMethod.setServicePathIntern(MockServicesUtil.getUrlWithReplacedDynVars(apiMethod.getServicePath()));
        } else {
            dbMethod.setServicePathIntern(apiMethod.getServicePath());
        }
    }

    private void setMethodHttpMethod(InterfaceMethod apiMethod, de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod) {
        HttpMethod httpMethod = apiMethod.getHttpMethod();
        if (httpMethod != null) {
            dbMethod.setHttpMethod(httpMethod.name());
        }
    }

    private de.joergdev.mosy.backend.persistence.model.InterfaceMethod loadOrCreateDbMethod(Interface dbInterface, InterfaceMethod apiMethod, de.joergdev.mosy.api.model.RecordConfig apiRecordConfig) {
        de.joergdev.mosy.backend.persistence.model.InterfaceMethod dbMethod;
        if (apiMethod.getInterfaceMethodId() != null) {
            dbMethod = this.findDbEntity(de.joergdev.mosy.backend.persistence.model.InterfaceMethod.class, apiMethod.getInterfaceMethodId(), "interface method with id " + apiMethod.getInterfaceMethodId());
            RecordConfig dbRecordConf = this.getDao(RecordConfigDAO.class).getByInterfaceMethodId(apiMethod.getInterfaceMethodId());
            if (dbRecordConf != null) {
                apiRecordConfig.setRecordConfigId(dbRecordConf.getRecordConfigId());
                apiRecordConfig.setEnabled(dbRecordConf.getEnabled());
            }
        } else {
            dbMethod = new de.joergdev.mosy.backend.persistence.model.InterfaceMethod();
            dbMethod.setMockInterface(dbInterface);
        }
        return dbMethod;
    }

    private void checkUniqueDataInterfaceMethod(InterfaceMethod apiMethod) {
        this.leaveOn(this.getDao(InterfaceMethodDAO.class).existsByInterfaceIdName(this.id, apiMethod.getName(), apiMethod.getInterfaceMethodId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interface method with name: " + apiMethod.getName()));
        String servicePath = apiMethod.getServicePath();
        this.leaveOn(servicePath != null && this.getDao(InterfaceMethodDAO.class).existsByInterfaceIdServicePath(this.id, servicePath, false, apiMethod.getHttpMethod(), apiMethod.getInterfaceMethodId()), ResponseCode.DATA_ALREADY_EXISTS.withAddtitionalInfo("interface method with service path: " + apiMethod.getServicePath()));
    }

    private void saveRecordConfig(de.joergdev.mosy.api.model.RecordConfig apiRecordConfig, de.joergdev.mosy.api.model.Interface mockInterface, InterfaceMethod interfaceMethod, Boolean apiRecordEnabled) {
        if (apiRecordEnabled == null) {
            if (apiRecordConfig.getRecordConfigId() != null) {
                this.dbInterface.setRecordConfig(null);
                this.invokeSubBL(new Delete(), apiRecordConfig.getRecordConfigId(), new EmptyResponse());
            }
        } else {
            if (Utils.isEqual((Object)apiRecordEnabled, (Object)apiRecordConfig.getEnabled()) && apiRecordConfig.getRecordConfigId() != null) {
                return;
            }
            apiRecordConfig.setEnabled(apiRecordEnabled);
            apiRecordConfig.setMockInterface(mockInterface);
            apiRecordConfig.setInterfaceMethod(interfaceMethod);
            this.invokeSubBL(new de.joergdev.mosy.backend.bl.recordconfig.Save(), apiRecordConfig, new SaveResponse());
        }
    }

    @Override
    protected void fillOutput() {
        de.joergdev.mosy.api.model.Interface apiInterfaceResp = new de.joergdev.mosy.api.model.Interface();
        apiInterfaceResp.setInterfaceId(this.dbInterface.getInterfaceId());
        apiInterfaceResp.setServicePath(this.dbInterface.getServicePath());
        for (InterfaceMethod apiMethod : ((de.joergdev.mosy.api.model.Interface)this.request).getMethods()) {
            if (apiMethod.isDelete()) continue;
            InterfaceMethod apiMethodResp = new InterfaceMethod();
            apiMethodResp.setInterfaceMethodId(apiMethod.getInterfaceMethodId());
            apiMethodResp.setName(apiMethod.getName());
            apiMethodResp.setServicePath(apiMethod.getServicePath());
            apiInterfaceResp.getMethods().add(apiMethodResp);
        }
        ((de.joergdev.mosy.api.response._interface.SaveResponse)this.response).setInterface(apiInterfaceResp);
    }
}

