/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.api.impl;

import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.request.system.LoginRequest;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.system.LoadBaseDataResponse;
import de.joergdev.mosy.api.response.system.LoginResponse;
import de.joergdev.mosy.backend.api.APIUtils;
import de.joergdev.mosy.backend.bl.system.Boot;
import de.joergdev.mosy.backend.bl.system.ImportData;
import de.joergdev.mosy.backend.bl.system.LoadBaseData;
import de.joergdev.mosy.backend.bl.system.Login;
import de.joergdev.mosy.backend.bl.system.Logout;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;

@Path(value="mosy/api/v_5_0/system")
public class System {
    @Path(value="login")
    @POST
    public Response login(LoginRequest loginRequest) {
        return APIUtils.executeBL(loginRequest, new LoginResponse(), new Login());
    }

    @Path(value="logout")
    @POST
    public Response logout(@HeaderParam(value="Authorization") String token) {
        return APIUtils.executeBL(null, new EmptyResponse(), new Logout(), token);
    }

    @Path(value="load-basedata")
    @GET
    public Response loadBaseData(@HeaderParam(value="Authorization") String token) {
        return APIUtils.executeBL(null, new LoadBaseDataResponse(), new LoadBaseData(), token);
    }

    @Path(value="import-data")
    @POST
    public Response importData(@HeaderParam(value="Authorization") String token, BaseData apiBaseData) {
        return APIUtils.executeBL(apiBaseData, new EmptyResponse(), new ImportData(), token);
    }

    @Path(value="boot")
    @POST
    public Response boot(@HeaderParam(value="Authorization") String token) {
        return APIUtils.executeBL(null, new EmptyResponse(), new Boot(), token);
    }

    @Path(value="state")
    @GET
    public Response getState() {
        return Response.ok().build();
    }

    @Path(value="version")
    @GET
    public Response getVersion() {
        return Response.ok().entity((Object)"5.0.0").build();
    }

    @Path(value="state-subsystem/{subsystem}")
    @GET
    public Response getStateSubsystem(@PathParam(value="subsystem") String subsystem) {
        if ("SUBSYSTEM_PERSISTENCE".equals(subsystem)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No subsystem " + subsystem)).build();
    }
}

