/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.war;

import de.joergdev.mosy.backend.persistence.EntityManagerProvider;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;

public class EntityManagerProviderImpl
implements EntityManagerProvider {
    public EntityManager getEntityManager() {
        try {
            EntityManager em = (EntityManager)new InitialContext().lookup("java:/mosy/entityManager");
            UserTransaction transaction = this.getTransaction();
            int txStatus = transaction.getStatus();
            if (6 == txStatus) {
                transaction.begin();
            }
            return em;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private UserTransaction getTransaction() throws NamingException {
        UserTransaction transaction = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        return transaction;
    }

    public void releaseEntityManager(EntityManager em) {
        try {
            UserTransaction transaction = this.getTransaction();
            if (transaction != null && 0 == transaction.getStatus()) {
                transaction.commit();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void rollbackEntityManager(EntityManager em) {
        try {
            UserTransaction transaction = this.getTransaction();
            if (transaction != null && (0 == transaction.getStatus() || 1 == transaction.getStatus())) {
                transaction.rollback();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean isContainerManaged() {
        return true;
    }
}

