/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.standalone.pool;

import de.joergdev.mosy.backend.standalone.pool.IPoolMethods;
import de.joergdev.mosy.backend.standalone.pool.ObjectPool;
import de.joergdev.mosy.backend.standalone.pool.PoolObject;
import de.joergdev.mosy.shared.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ObjectPool<T> {
    public static final long TTL_UNLIMITED = -1L;
    private List<PoolObject<T>> poolObjects;
    private IPoolMethods<T> poolMethodsImpl;
    private Lock lock;
    private Runnable checkPool = new /* Unavailable Anonymous Inner Class!! */;

    public ObjectPool(IPoolMethods<T> impl) {
        this(false, impl);
    }

    public ObjectPool(IPoolMethods<T> impl, int initialSize) {
        this(false, impl, initialSize);
    }

    public ObjectPool(boolean concurrent, IPoolMethods<T> impl) {
        this(concurrent, impl, 0);
    }

    public ObjectPool(boolean concurrent, IPoolMethods<T> impl, int initialSize) {
        this(concurrent, impl, (Lock)(concurrent ? new ReentrantLock() : new NullLock(null)), initialSize);
    }

    public ObjectPool(boolean concurrent, IPoolMethods<T> impl, Lock lock) {
        this(concurrent, impl, lock, 0);
    }

    public ObjectPool(boolean concurrent, IPoolMethods<T> impl, Lock lock, int initialSize) {
        this.checkPoolMethodsImpl(impl);
        this.poolMethodsImpl = impl;
        this.poolObjects = concurrent ? new CopyOnWriteArrayList() : new ArrayList();
        this.setLock(lock);
        this.initialInit(initialSize);
        if (-1L != impl.getTTL()) {
            Thread threadClean = new Thread(this.checkPool);
            threadClean.setDaemon(true);
            threadClean.start();
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(Lock lock) {
        if (lock == null) {
            throw new NullPointerException("lock may not be null");
        }
        this.lock = lock;
    }

    private void checkPoolMethodsImpl(IPoolMethods<T> impl) {
        if (impl == null) {
            throw new NullPointerException("IPoolMethods Impl may not be null");
        }
        if (impl.getMaxSize() < 1) {
            throw new IllegalArgumentException("MaxPoolSize may not be smaller than 1");
        }
        if (-1L != impl.getTTL()) {
            if (impl.getCheckInterval() < 10000L) {
                throw new IllegalArgumentException("CheckInterval may not be smaller than 10 seconds");
            }
            if (impl.getTTL() < 10000L) {
                throw new IllegalArgumentException("TTL may not be smaller than 10 seconds");
            }
        }
    }

    private void initialInit(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("initialSize may not be negative");
        }
        if (initialSize == 0) {
            return;
        }
        if (initialSize > this.poolMethodsImpl.getMaxSize()) {
            throw new IllegalArgumentException("initialSize may not be bigger than maxPoolSize");
        }
        for (int x = 0; x < initialSize; ++x) {
            PoolObject obj = new PoolObject(this.poolMethodsImpl.getNewObj(), false);
            this.poolObjects.add(obj);
        }
    }

    public T get() {
        this.lock.lock();
        try {
            PoolObject obj = this.getFreePoolObject();
            if (obj == null) {
                if (this.poolObjects.size() < this.poolMethodsImpl.getMaxSize()) {
                    obj = new PoolObject(this.poolMethodsImpl.getNewObj(), true);
                    this.poolObjects.add(obj);
                } else {
                    Utils.delay((long)20L);
                    Object object = this.get();
                    return (T)object;
                }
            }
            if (this.poolMethodsImpl.validateOnGet() && !this.poolMethodsImpl.validate(obj.getObj())) {
                this.poolObjects.remove(obj);
                this.poolMethodsImpl.cleanup(obj.getObj());
                Object object = this.get();
                return (T)object;
            }
            Object object = obj.getObj();
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private PoolObject<T> getFreePoolObject() {
        for (PoolObject poolObj : this.poolObjects) {
            if (poolObj.isLocked()) continue;
            poolObj.setLocked(true);
            return poolObj;
        }
        return null;
    }

    public void giveBack(T obj) {
        for (PoolObject poolObj : this.poolObjects) {
            if (!poolObj.getObj().equals(obj)) continue;
            if (this.poolMethodsImpl.validateOnGiveBack() && !this.poolMethodsImpl.validate(obj)) {
                this.poolObjects.remove(poolObj);
                this.poolMethodsImpl.cleanup(obj);
                return;
            }
            poolObj.setLocked(false);
            poolObj.setTimeGaveBack(System.currentTimeMillis());
            return;
        }
    }

    public int getPoolSize() {
        return this.poolObjects.size();
    }

    public int getUnlockedCount() {
        int size = 0;
        for (PoolObject obj : this.poolObjects) {
            if (obj.isLocked()) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPool() {
        for (PoolObject poolObj : this.poolObjects) {
            boolean unlocked = false;
            try {
                this.lock.lock();
                if (poolObj.isLocked()) continue;
                poolObj.setLocked(true);
                this.lock.unlock();
                unlocked = true;
                this.poolObjects.remove(poolObj);
                this.poolMethodsImpl.cleanup(poolObj.getObj());
            }
            finally {
                if (unlocked) continue;
                this.lock.unlock();
            }
        }
    }

    static /* synthetic */ IPoolMethods access$100(ObjectPool x0) {
        return x0.poolMethodsImpl;
    }

    static /* synthetic */ List access$200(ObjectPool x0) {
        return x0.poolObjects;
    }

    static /* synthetic */ Lock access$300(ObjectPool x0) {
        return x0.lock;
    }
}

