/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.standalone.persistence;

import de.joergdev.mosy.backend.persistence.EntityManagerProvider;
import de.joergdev.mosy.backend.standalone.persistence.EntityManagerPoolMethodsImpl;
import de.joergdev.mosy.backend.standalone.pool.IPoolMethods;
import de.joergdev.mosy.backend.standalone.pool.ObjectPool;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class EntityManagerProviderImpl
implements EntityManagerProvider {
    private static final Logger LOG = Logger.getLogger(EntityManagerProviderImpl.class);
    private ObjectPool<EntityManager> emPool = null;

    public EntityManager getEntityManager() {
        try {
            this.initEntityManagerPool();
            return (EntityManager)this.emPool.get();
        }
        catch (RuntimeException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    private synchronized void initEntityManagerPool() {
        if (this.emPool != null) {
            return;
        }
        try {
            this.emPool = new ObjectPool(true, (IPoolMethods)new EntityManagerPoolMethodsImpl(), 1);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void releaseEntityManager(EntityManager em) {
        this.emPool.giveBack((Object)em);
    }

    public void rollbackEntityManager(EntityManager em) {
        EntityTransaction tx;
        if (em != null && (tx = em.getTransaction()) != null) {
            tx.rollback();
        }
    }

    public boolean isContainerManaged() {
        return false;
    }
}

