/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.backend.standalone.persistence;

import de.joergdev.mosy.backend.standalone.persistence.DbUtils;
import de.joergdev.mosy.backend.standalone.pool.IPoolMethods;
import de.joergdev.mosy.shared.Utils;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

public class EntityManagerPoolMethodsImpl
implements IPoolMethods<EntityManager> {
    public static final String SYSTEM_PROPERTY_MAX_POOL_SIZE = "MOSY_DB_MAX_POOL_SIZE";
    private static final int DEFAULT_MAX_POOL_SIZE = 5;

    public void cleanup(EntityManager em) {
        block11: {
            try {
                if (em == null) break block11;
                EntityManagerFactory emf = em.getEntityManagerFactory();
                try {
                    EntityTransaction tx = em.getTransaction();
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (em.isOpen()) {
                        em.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (emf != null && emf.isOpen()) {
                        emf.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getCheckInterval() {
        return 0L;
    }

    public EntityManager getNewObj() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"db");
        return emf.createEntityManager();
    }

    public long getTTL() {
        return -1L;
    }

    public int getMaxSize() {
        String sysProp = Utils.getSystemProperty((String)SYSTEM_PROPERTY_MAX_POOL_SIZE);
        return Utils.isEmpty((String)sysProp) ? 5 : Utils.asInteger((String)sysProp);
    }

    public boolean validate(EntityManager em) {
        return DbUtils.validateEntityManager((EntityManager)em);
    }

    public boolean validateOnGet() {
        return false;
    }

    public boolean validateOnGiveBack() {
        return true;
    }
}

