/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.api.client;

import de.joergdev.mosy.shared.Utils;
import java.util.ResourceBundle;

public class Resources {
    public static final String SYSTEM_PROPERTY_API_ENDPOINT = "MOSY_API_ENDPOINT";
    private static final String PROPERTY_API_ENDPOINT = "api_endpoint";
    private static final ResourceBundle MOSY_API_CLIENT = ResourceBundle.getBundle("mosy_api_client");
    private static final ResourceBundle ERROR_MESSAGES = ResourceBundle.getBundle("mosy_api_client_error_messages");

    public static String getApiEndpoint() {
        String sysProp = Utils.getSystemProperty((String)SYSTEM_PROPERTY_API_ENDPOINT);
        if (!Utils.isEmpty((String)sysProp)) {
            return sysProp;
        }
        return Resources.getProperty(PROPERTY_API_ENDPOINT);
    }

    public static String getProperty(String key) {
        return MOSY_API_CLIENT.getString(key);
    }

    public static String getErrorMessage(String key, String ... details) {
        return Resources.getMessage(ERROR_MESSAGES, key, details);
    }

    private static String getMessage(ResourceBundle rb, String key, String ... details) {
        String msg = rb.getString(key);
        if (details != null && details.length > 0) {
            msg = String.format(msg, details);
        }
        return msg;
    }
}

