/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.api.client;

import de.joergdev.mosy.api.client.Resources;
import de.joergdev.mosy.api.response.ResponseMessage;
import de.joergdev.mosy.api.response.ResponseMessageLevel;
import java.util.Collection;

public class MosyApiClientException
extends RuntimeException {
    private final Collection<ResponseMessage> responseMessages;

    public MosyApiClientException(Collection<ResponseMessage> responseMessages) {
        super(MosyApiClientException.buildErrorMessage(responseMessages));
        this.responseMessages = responseMessages;
    }

    private static String buildErrorMessage(Collection<ResponseMessage> responseMessages) {
        StringBuilder buiMsg = new StringBuilder();
        for (ResponseMessage rm : responseMessages) {
            if (buiMsg.length() > 0) {
                buiMsg.append("\n");
            }
            if (ResponseMessageLevel.FATAL.equals((Object)rm.getResponseCode().level)) {
                buiMsg.append("FATAL: ");
            }
            buiMsg.append(rm.getFullMessage());
        }
        if (buiMsg.length() == 0) {
            buiMsg.append(Resources.getErrorMessage("unknown_error", new String[0]));
        }
        return buiMsg.toString();
    }

    public Collection<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }
}

