/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.api.client;

import de.joergdev.mosy.api.client.CustomMockArguments;
import de.joergdev.mosy.api.client.MosyApiClient;
import de.joergdev.mosy.api.model.Record;
import de.joergdev.mosy.api.model.RecordSession;
import de.joergdev.mosy.api.request.mockservices.CustomRequestRequest;
import de.joergdev.mosy.api.response.mockservices.CustomRequestResponse;
import de.joergdev.mosy.api.response.record.SaveResponse;

public abstract class AbstractCustomMockImpl<T> {
    protected final CustomMockArguments customMockArguments;
    private MosyApiClient mosyApiClient;
    private boolean recordResponse = false;
    private Record mockRecord = null;

    public AbstractCustomMockImpl(CustomMockArguments customMockArguments) {
        this.customMockArguments = customMockArguments;
    }

    public T getMockResponse() {
        if (this.customMockArguments.isMockEnabled()) {
            CustomRequestRequest req = new CustomRequestRequest();
            this.fillCustomRequestRequest(req);
            this.mosyApiClient = this.getMosyApiClient();
            CustomRequestResponse response = this.mosyApiClient.customRequest(req, this.customMockArguments.getMockProfileName(), this.customMockArguments.getRecordSessionID(), this.customMockArguments.getTenantId());
            if (response.isRoute()) {
                this.preFillRecord(req, response);
            } else {
                return this.getMockResponse(response);
            }
        }
        return null;
    }

    public SaveResponse recordResponse(String response) {
        this.mockRecord.setResponse(response);
        return this.mosyApiClient.saveRecord(this.mockRecord);
    }

    public abstract void fillCustomRequestRequest(CustomRequestRequest var1);

    public abstract MosyApiClient getMosyApiClient();

    public abstract T getMockResponse(CustomRequestResponse var1);

    private void preFillRecord(CustomRequestRequest req, CustomRequestResponse response) {
        if (response.isRecord()) {
            this.setRecordResponse(true);
            this.mockRecord = new Record();
            this.mockRecord.setInterfaceMethod(response.getInterfaceMethod());
            this.mockRecord.setRequestData(req.getRequest());
            Integer recordSessionID = this.customMockArguments.getRecordSessionID();
            if (recordSessionID != null) {
                this.mockRecord.setRecordSession(new RecordSession(recordSessionID));
            }
        }
    }

    public boolean isRecordResponse() {
        return this.recordResponse;
    }

    public void setRecordResponse(boolean recordResponse) {
        this.recordResponse = recordResponse;
    }

    public Record getMockRecord() {
        return this.mockRecord;
    }

    public void setMockRecord(Record mockRecord) {
        this.mockRecord = mockRecord;
    }
}

