/*
 * Decompiled with CFR 0.152.
 */
package de.joergdev.mosy.api.client;

import de.joergdev.mosy.api.client.MosyApiClientException;
import de.joergdev.mosy.api.client.Resources;
import de.joergdev.mosy.api.model.BaseData;
import de.joergdev.mosy.api.model.HttpMethod;
import de.joergdev.mosy.api.model.Interface;
import de.joergdev.mosy.api.model.MockData;
import de.joergdev.mosy.api.model.MockProfile;
import de.joergdev.mosy.api.model.Record;
import de.joergdev.mosy.api.model.RecordConfig;
import de.joergdev.mosy.api.model.Tenant;
import de.joergdev.mosy.api.request.mockservices.CustomRequestRequest;
import de.joergdev.mosy.api.request.system.LoginRequest;
import de.joergdev.mosy.api.request.tenant.SaveRequest;
import de.joergdev.mosy.api.response.AbstractResponse;
import de.joergdev.mosy.api.response.EmptyResponse;
import de.joergdev.mosy.api.response.ResponseMessageLevel;
import de.joergdev.mosy.api.response._interface.LoadResponse;
import de.joergdev.mosy.api.response._interface.method.LoadMockDataResponse;
import de.joergdev.mosy.api.response._interface.method.LoadRecordConfigsResponse;
import de.joergdev.mosy.api.response.mockprofile.LoadProfilesResponse;
import de.joergdev.mosy.api.response.mockservices.CustomRequestResponse;
import de.joergdev.mosy.api.response.record.session.CreateResponse;
import de.joergdev.mosy.api.response.record.session.LoadSessionsResponse;
import de.joergdev.mosy.api.response.system.LoadBaseDataResponse;
import de.joergdev.mosy.api.response.system.LoginResponse;
import de.joergdev.mosy.api.response.tenant.LoadAllResponse;
import de.joergdev.mosy.api.response.tenant.SaveResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.log4j.Logger;

public class MosyApiClient {
    private static final Logger LOG = Logger.getLogger(MosyApiClient.class);
    private String token;

    public MosyApiClient() {
    }

    public MosyApiClient(String token) {
        this.token = token;
    }

    public LoginResponse systemLogin(Integer hash) {
        return this.systemLogin(null, hash);
    }

    public LoginResponse systemLogin(Integer tenantId, Integer hash) {
        LoginRequest request = new LoginRequest();
        request.setTenantId(tenantId);
        request.setSecretHash(hash);
        LoginResponse response = this.invokeApiPostCall("system/login", LoginResponse.class, request);
        this.token = response.getToken();
        return response;
    }

    public EmptyResponse systemLogout() {
        return this.invokeApiPostCall("system/logout", EmptyResponse.class, null);
    }

    public LoadBaseDataResponse systemLoadBasedata() {
        return this.invokeApiGetCall("system/load-basedata", LoadBaseDataResponse.class);
    }

    public EmptyResponse systemBoot() {
        return this.invokeApiPostCall("system/boot", EmptyResponse.class, null);
    }

    public LoadAllResponse loadTenants() {
        return this.invokeApiGetCall("tenants", LoadAllResponse.class);
    }

    public SaveResponse saveTenant(Tenant apiTenant) {
        return this.saveTenant(apiTenant, null);
    }

    public SaveResponse saveTenant(Tenant apiTenant, Integer secretHash) {
        SaveRequest req = new SaveRequest();
        req.setTenant(apiTenant);
        req.setSecretHash(secretHash);
        return this.invokeApiPostCall("tenants/save", SaveResponse.class, req);
    }

    public EmptyResponse deleteTenant(Integer id) {
        return this.invokeApiDeleteCall("tenants/" + id + "/delete", EmptyResponse.class);
    }

    public EmptyResponse globalConfigSave(BaseData basedata) {
        return this.invokeApiPostCall("globalconfig/save", EmptyResponse.class, basedata);
    }

    public de.joergdev.mosy.api.response.record.LoadAllResponse loadRecords(Integer loadCount, Integer lastLoadedId, Integer recordSessionID) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("load_count", loadCount);
        queryParams.put("last_loaded_id", lastLoadedId);
        queryParams.put("record_session_id", recordSessionID);
        return this.invokeApiGetCall("records", de.joergdev.mosy.api.response.record.LoadAllResponse.class, queryParams);
    }

    public de.joergdev.mosy.api.response.record.LoadResponse loadRecord(Integer id) {
        return this.invokeApiGetCall("records/" + id, de.joergdev.mosy.api.response.record.LoadResponse.class);
    }

    public de.joergdev.mosy.api.response.record.SaveResponse saveRecord(Record apiRecord) {
        return this.invokeApiPostCall("records/save", de.joergdev.mosy.api.response.record.SaveResponse.class, apiRecord);
    }

    public EmptyResponse deleteRecord(Integer id) {
        return this.invokeApiDeleteCall("records/" + id + "/delete", EmptyResponse.class);
    }

    public EmptyResponse deleteRecords() {
        return this.invokeApiDeleteCall("records/delete", EmptyResponse.class);
    }

    public LoadSessionsResponse loadRecordSessions() {
        return this.invokeApiGetCall("record-sessions", LoadSessionsResponse.class);
    }

    public CreateResponse createRecordSession() {
        return this.invokeApiPostCall("record-sessions/create", CreateResponse.class, null);
    }

    public EmptyResponse deleteRecordSession(Integer id) {
        return this.invokeApiDeleteCall("record-sessions/" + id + "/delete", EmptyResponse.class);
    }

    public LoadProfilesResponse loadMockProfiles() {
        return this.invokeApiGetCall("mock-profiles", LoadProfilesResponse.class);
    }

    public de.joergdev.mosy.api.response.mockprofile.SaveResponse saveMockProfile(MockProfile apiMockProfile) {
        return this.invokeApiPostCall("mock-profiles/save", de.joergdev.mosy.api.response.mockprofile.SaveResponse.class, apiMockProfile);
    }

    public de.joergdev.mosy.api.response.mockprofile.LoadResponse loadMockProfile(Integer id) {
        return this.invokeApiGetCall("mock-profiles/" + id, de.joergdev.mosy.api.response.mockprofile.LoadResponse.class);
    }

    public EmptyResponse deleteMockProfile(Integer id) {
        return this.invokeApiDeleteCall("mock-profiles/" + id + "/delete", EmptyResponse.class);
    }

    public de.joergdev.mosy.api.response.mockprofile.LoadMockDataResponse loadMockProfileMockData(String name) {
        return this.loadMockProfileMockData((Object)name);
    }

    public de.joergdev.mosy.api.response.mockprofile.LoadMockDataResponse loadMockProfileMockData(Integer id) {
        return this.loadMockProfileMockData((Object)id);
    }

    private de.joergdev.mosy.api.response.mockprofile.LoadMockDataResponse loadMockProfileMockData(Object key) {
        return this.invokeApiGetCall("mock-profiles/" + key + "/mockdata", de.joergdev.mosy.api.response.mockprofile.LoadMockDataResponse.class);
    }

    public LoadResponse loadInterface(Integer id) {
        return this.invokeApiGetCall("interfaces/" + id, LoadResponse.class);
    }

    public de.joergdev.mosy.api.response._interface.SaveResponse saveInterface(Interface apiInterface) {
        return this.invokeApiPostCall("interfaces/save", de.joergdev.mosy.api.response._interface.SaveResponse.class, apiInterface);
    }

    public EmptyResponse deleteInterface(Integer id) {
        return this.invokeApiDeleteCall("interfaces/" + id + "/delete", EmptyResponse.class);
    }

    public LoadMockDataResponse loadMethodMockData(Integer interfaceID, Integer methodID) {
        return this.invokeApiGetCall("interfaces/" + interfaceID + "/methods/" + methodID + "/mockdata", LoadMockDataResponse.class);
    }

    public LoadRecordConfigsResponse loadMethodRecordConfigs(Integer interfaceID, Integer methodID) {
        return this.invokeApiGetCall("interfaces/" + interfaceID + "/methods/" + methodID + "/recordconfigs", LoadRecordConfigsResponse.class);
    }

    public de.joergdev.mosy.api.response.recordconfig.LoadResponse loadRecordConfig(Integer id) {
        return this.invokeApiGetCall("record-config/" + id, de.joergdev.mosy.api.response.recordconfig.LoadResponse.class);
    }

    public de.joergdev.mosy.api.response.recordconfig.SaveResponse saveRecordConfig(RecordConfig apiRecordConfig) {
        return this.invokeApiPostCall("record-config/save", de.joergdev.mosy.api.response.recordconfig.SaveResponse.class, apiRecordConfig);
    }

    public EmptyResponse deleteRecordConfig(Integer id) {
        return this.invokeApiDeleteCall("record-config/" + id + "/delete", EmptyResponse.class);
    }

    public de.joergdev.mosy.api.response.mockdata.LoadResponse loadMockData(Integer id) {
        return this.invokeApiGetCall("mockdata/" + id, de.joergdev.mosy.api.response.mockdata.LoadResponse.class);
    }

    public de.joergdev.mosy.api.response.mockdata.SaveResponse saveMockData(MockData apiMockData) {
        return this.invokeApiPostCall("mockdata/save", de.joergdev.mosy.api.response.mockdata.SaveResponse.class, apiMockData);
    }

    public EmptyResponse deleteMockData(Integer id) {
        return this.invokeApiDeleteCall("mockdata/" + id + "/delete", EmptyResponse.class);
    }

    public CustomRequestResponse customRequest(CustomRequestRequest request, String mockProfileName, Integer recordSessionID) {
        return this.customRequest(request, mockProfileName, recordSessionID, null);
    }

    public CustomRequestResponse customRequest(CustomRequestRequest request, String mockProfileName, Integer recordSessionID, Integer tenantId) {
        return this.invokeApiPostCall("mock-services/custom-request", CustomRequestResponse.class, request, mockProfileName, recordSessionID, tenantId);
    }

    private <T extends AbstractResponse> T invokeApiGetCall(String path, Class<T> responseClass) {
        return this.invokeApiGetCall(path, responseClass, null);
    }

    private <T extends AbstractResponse> T invokeApiGetCall(String path, Class<T> responseClass, Map<String, Object> queryParams) {
        return this.invokeApiCall(path, HttpMethod.GET, responseClass, null, queryParams, null, null, null);
    }

    private <T extends AbstractResponse> T invokeApiPutCall(String path, Class<T> responseClass, Object entity) {
        return this.invokeApiCall(path, HttpMethod.PUT, responseClass, entity, null, null, null, null);
    }

    private <T extends AbstractResponse> T invokeApiPostCall(String path, Class<T> responseClass, Object entity, String mockProfileName, Integer recordSessionID, Integer tenantId) {
        return this.invokeApiCall(path, HttpMethod.POST, responseClass, entity, null, mockProfileName, recordSessionID, tenantId);
    }

    private <T extends AbstractResponse> T invokeApiPostCall(String path, Class<T> responseClass, Object entity) {
        return this.invokeApiCall(path, HttpMethod.POST, responseClass, entity, null, null, null, null);
    }

    private <T extends AbstractResponse> T invokeApiDeleteCall(String path, Class<T> responseClass) {
        return this.invokeApiCall(path, HttpMethod.DELETE, responseClass, null, null, null, null, null);
    }

    private <T extends AbstractResponse> T invokeApiCall(String path, HttpMethod method, Class<T> responseClass, Object entity, Map<String, Object> queryParams, String mockProfileName, Integer recordSessionID, Integer tenantId) {
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(Resources.getApiEndpoint());
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            webTarget = webTarget.path(tok.nextToken());
        }
        if (queryParams != null) {
            for (String queryParamKey : queryParams.keySet()) {
                Object queryParamValue = queryParams.get(queryParamKey);
                if (queryParamValue == null) continue;
                webTarget = webTarget.queryParam(queryParamKey, new Object[]{queryParamValue});
            }
        }
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        if (this.token != null) {
            invocationBuilder.header("Authorization", (Object)this.token);
        }
        if (tenantId != null) {
            invocationBuilder.header("HTTP_HEADER_TENANT_ID", (Object)tenantId);
        }
        if (mockProfileName != null) {
            invocationBuilder.header("HTTP_HEADER_MOCK_PROFILE_NAME", (Object)mockProfileName);
        }
        if (recordSessionID != null) {
            invocationBuilder.header("HTTP_HEADER_RECORD_SESSION_ID", (Object)String.valueOf(recordSessionID));
        }
        T response = this.invokeAndGetResponse(method, responseClass, entity, invocationBuilder, webTarget.getUri().toString());
        this.checkForError(response);
        return response;
    }

    private <T extends AbstractResponse> void checkForError(T response) {
        Objects.requireNonNull(response);
        if (!response.isStateOK()) {
            throw new MosyApiClientException(response.getMessagesForLevel(new ResponseMessageLevel[]{ResponseMessageLevel.FATAL, ResponseMessageLevel.ERROR}));
        }
    }

    private <T extends AbstractResponse> T invokeAndGetResponse(HttpMethod method, Class<T> responseClass, Object entity, Invocation.Builder invocationBuilder, String endpoint) {
        AbstractResponse response = null;
        long timeStart = 0L;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Invoke API-Call " + endpoint));
            timeStart = System.currentTimeMillis();
        }
        if (HttpMethod.GET.equals((Object)method)) {
            response = (AbstractResponse)invocationBuilder.get(responseClass);
        } else if (HttpMethod.PUT.equals((Object)method)) {
            response = (AbstractResponse)invocationBuilder.put(Entity.entity((Object)entity, (String)"application/json"), responseClass);
        } else if (HttpMethod.POST.equals((Object)method)) {
            response = (AbstractResponse)invocationBuilder.post(Entity.entity((Object)entity, (String)"application/json"), responseClass);
        } else if (HttpMethod.DELETE.equals((Object)method)) {
            response = (AbstractResponse)invocationBuilder.delete(responseClass);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Invoked API-Call " + endpoint + "; time (ms): " + (System.currentTimeMillis() - timeStart)));
        }
        return (T)response;
    }
}

